/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.io.IConversionService;
import com.prowidesoftware.swift.io.parser.SwiftParser;
import com.prowidesoftware.swift.io.parser.XMLParser;
import com.prowidesoftware.swift.io.writer.SwiftWriter;
import com.prowidesoftware.swift.io.writer.XMLWriterVisitor;
import com.prowidesoftware.swift.model.SwiftMessage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;

public class ConversionService
implements IConversionService {
    private static final transient Logger log = Logger.getLogger(ConversionService.class.getName());

    @Override
    public String getFIN(SwiftMessage msg) {
        Validate.notNull((Object)msg);
        StringWriter writer = new StringWriter();
        SwiftWriter.writeMessage(msg, writer);
        String fin = writer.getBuffer().toString();
        return ConversionService.ensureEols(fin);
    }

    private static String ensureEols(String result) {
        StringBuilder buf = new StringBuilder();
        try {
            String l;
            BufferedReader r = new BufferedReader(new StringReader(result));
            while ((l = r.readLine()) != null) {
                buf.append(l).append("\r\n");
            }
        }
        catch (Exception e) {
            log.severe("Error in EOL correction: " + e);
        }
        if (buf.length() > 0) {
            return buf.substring(0, buf.length() - "\r\n".length());
        }
        return "";
    }

    @Override
    public String getFIN(String xml) {
        Validate.notNull((Object)xml);
        SwiftMessage msg = this.getMessageFromXML(xml);
        if (msg == null) {
            throw new ProwideException("parsed SwiftMessage from XML is null");
        }
        return this.getFIN(msg);
    }

    @Override
    public String getXml(SwiftMessage msg) {
        return this.getXml(msg, false);
    }

    public String getXml(SwiftMessage msg, boolean useField) {
        Validate.notNull((Object)msg);
        StringWriter w = new StringWriter();
        msg.visit(new XMLWriterVisitor(w, useField));
        return w.getBuffer().toString();
    }

    @Override
    public String getXml(String fin) {
        return this.getXml(fin, false);
    }

    public String getXml(String fin, boolean useField) {
        Validate.notNull((Object)fin);
        SwiftMessage msg = this.getMessageFromFIN(fin);
        return this.getXml(msg, useField);
    }

    @Override
    public SwiftMessage getMessageFromFIN(String fin) {
        Validate.notNull((Object)fin);
        SwiftParser p = new SwiftParser(new ByteArrayInputStream(fin.getBytes()));
        try {
            return p.message();
        }
        catch (IOException e) {
            throw new ProwideException(e + " during parse of message");
        }
    }

    @Override
    public SwiftMessage getMessageFromXML(String xml) {
        return new XMLParser().parse(xml);
    }
}

