/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import com.prowidesoftware.swift.io.AbstractWriter;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.lang3.Validate;

public class PPCWriter
extends AbstractWriter {
    public PPCWriter(Writer writer) {
        super(writer);
    }

    public PPCWriter(File file) throws FileNotFoundException {
        super(file);
    }

    public PPCWriter(String filename) throws FileNotFoundException {
        super(filename);
    }

    public PPCWriter(OutputStream stream) {
        super(stream);
    }

    public void write(String msg) throws IOException {
        PPCWriter.write(msg, this.writer);
    }

    public void write(AbstractMT msg) throws IOException {
        PPCWriter.write(msg, this.writer);
    }

    public static void write(AbstractMT msg, Writer writer) throws IOException {
        Validate.notNull((Object)msg, (String)"message to write cannot be null", (Object[])new Object[0]);
        PPCWriter.write(msg.message(), writer);
    }

    public static void write(String msg, Writer writer) throws IOException {
        Validate.notNull((Object)writer, (String)"writer has not been initialized", (Object[])new Object[0]);
        Validate.notNull((Object)msg, (String)"message to write cannot be null", (Object[])new Object[0]);
        writer.write(1);
        writer.write(msg);
        writer.write(3);
        int length = msg.length() + 2;
        int pad = length > 512 ? length % 512 : 512 - length;
        for (int i = 0; i < pad; ++i) {
            writer.write(32);
        }
    }
}

