/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.MxBusinessProcess;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public class MxId {
    private MxBusinessProcess businessProcess;
    private String functionality;
    private String variant;
    private String version;
    private static final Pattern pattern = Pattern.compile(".*([a-zA-Z]{4}).(\\d{3}).(\\d{3}).(\\d{2}).*");

    public MxId() {
        this.businessProcess = null;
        this.functionality = "";
        this.variant = "";
        this.version = "";
    }

    public MxId(String namespace) {
        Validate.notNull((Object)namespace);
        Matcher matcher = pattern.matcher(namespace);
        if (matcher.matches()) {
            String bpStr = matcher.group(1);
            try {
                this.businessProcess = MxBusinessProcess.valueOf(bpStr);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value for business process: '" + bpStr + "' see enum values in " + MxBusinessProcess.class.getName() + " for valid options", e);
            }
        } else {
            throw new IllegalArgumentException("Could not parse namespace '" + namespace + "'");
        }
        this.functionality = matcher.group(2);
        this.variant = matcher.group(3);
        this.version = matcher.group(4);
    }

    public MxId(String bpString, String funString, String varString, String verString) {
        this.businessProcess = MxBusinessProcess.valueOf(bpString);
        this.functionality = funString;
        this.variant = varString;
        this.version = verString;
    }

    public MxBusinessProcess getBusinessProcess() {
        return this.businessProcess;
    }

    public void setBusinessProcess(MxBusinessProcess businessProcess) {
        this.businessProcess = businessProcess;
    }

    public String getFunctionality() {
        return this.functionality;
    }

    public void setFunctionality(String functionality) {
        this.functionality = functionality;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String camelized() {
        StringBuilder sb = new StringBuilder();
        if (this.businessProcess != null) {
            sb.append(Character.toUpperCase(this.businessProcess.name().charAt(0)));
            sb.append(this.businessProcess.name().substring(1));
        }
        if (this.functionality != null) {
            sb.append(this.functionality);
        }
        if (this.variant != null) {
            sb.append(this.variant);
        }
        if (this.version != null) {
            sb.append(this.version);
        }
        return sb.toString();
    }

    public int getVersionInt() {
        return Integer.valueOf(this.getVersion());
    }

    public int getVariantInt() {
        return Integer.valueOf(this.getVariant());
    }

    public int getFunctionalityInt() {
        return Integer.valueOf(this.getFunctionality());
    }

    public String namespaceURI() {
        return "urn:swift:xsd:" + this.id();
    }

    public String id() {
        StringBuilder sb = new StringBuilder();
        if (this.businessProcess == null) {
            return null;
        }
        sb.append(this.businessProcess.name());
        if (this.functionality == null) {
            return null;
        }
        sb.append("." + this.functionality);
        if (this.variant == null) {
            return null;
        }
        sb.append("." + this.variant);
        if (this.version == null) {
            return null;
        }
        sb.append("." + this.version);
        return sb.toString();
    }

    public String toString() {
        return this.id();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MxId mxId = (MxId)o;
        return this.businessProcess == mxId.businessProcess && Objects.equals(this.functionality, mxId.functionality) && Objects.equals(this.variant, mxId.variant) && Objects.equals(this.version, mxId.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.businessProcess, this.functionality, this.variant, this.version});
    }
}

