/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftMessage;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class SwiftMessageAdapter
implements JsonDeserializer<SwiftMessage>,
JsonSerializer<SwiftMessage> {
    public JsonElement serialize(SwiftMessage src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String ts = dateFormat.format(Calendar.getInstance().getTime());
        object.addProperty("timestamp", ts);
        object.addProperty("version", (Number)2);
        JsonObject objectBlocks = new JsonObject();
        objectBlocks.add("block1", context.serialize((Object)src.getBlock1()));
        objectBlocks.add("block2", context.serialize((Object)src.getBlock2(), SwiftBlock2.class));
        objectBlocks.add("block3", context.serialize((Object)src.getBlock3()));
        objectBlocks.add("block4", context.serialize((Object)src.getBlock4()));
        objectBlocks.add("block5", context.serialize((Object)src.getBlock5()));
        object.add("data", (JsonElement)objectBlocks);
        return object;
    }

    public SwiftMessage deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonArray = jsonElement.getAsJsonObject().get("data").getAsJsonObject();
        SwiftBlock1 block1 = (SwiftBlock1)jsonDeserializationContext.deserialize(jsonArray.get("block1"), SwiftBlock1.class);
        SwiftBlock2 block2 = (SwiftBlock2)jsonDeserializationContext.deserialize(jsonArray.get("block2"), SwiftBlock2.class);
        SwiftBlock3 block3 = (SwiftBlock3)jsonDeserializationContext.deserialize(jsonArray.get("block3"), SwiftBlock3.class);
        SwiftBlock4 block4 = (SwiftBlock4)jsonDeserializationContext.deserialize(jsonArray.get("block4"), SwiftBlock4.class);
        SwiftBlock5 block5 = (SwiftBlock5)jsonDeserializationContext.deserialize(jsonArray.get("block5"), SwiftBlock5.class);
        ArrayList<SwiftBlockUser> blockUsers = new ArrayList<SwiftBlockUser>();
        if (jsonArray.get("userBlocks") != null) {
            for (JsonElement blockUser : jsonArray.get("userBlocks").getAsJsonArray()) {
                blockUsers.add((SwiftBlockUser)jsonDeserializationContext.deserialize(blockUser, SwiftBlockUser.class));
            }
        }
        SwiftMessage sm = new SwiftMessage();
        if (block1 != null) {
            sm.addBlock(block1);
        }
        if (block2 != null) {
            sm.addBlock(block2);
        }
        if (block3 != null) {
            sm.addBlock(block3);
        }
        if (block4 != null) {
            sm.addBlock(block4);
        }
        if (block5 != null) {
            sm.addBlock(block5);
        }
        if (blockUsers != null && blockUsers.size() > 0) {
            sm.setUserBlocks(blockUsers);
        }
        return sm;
    }
}

