/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.JsonSerializable;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.PatternContainer;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.time.DateFormatUtils;

public abstract class Field
implements PatternContainer,
JsonSerializable {
    private static final transient Logger log = Logger.getLogger(Field.class.getName());
    protected List<String> components;

    @Deprecated
    protected Field() {
    }

    protected Field(int components) {
        this.init(components);
    }

    protected void init(int components) {
        this.components = new ArrayList<String>(components);
        for (int i = 0; i < components; ++i) {
            this.components.add(null);
        }
    }

    protected Field(String value) {
        this.parse(value);
        for (int i = 0; i < this.components.size(); ++i) {
            if (!StringUtils.isEmpty((CharSequence)this.components.get(i))) continue;
            this.components.set(i, null);
        }
    }

    public abstract void parse(String var1);

    protected Field(Field source) {
        this.components = new ArrayList<String>(source.getComponents());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    protected static String formatNumber(Object aValue) {
        DecimalFormat fmt = new DecimalFormat("#,###.00");
        NumberFormat f = NumberFormat.getInstance(Locale.getDefault());
        if (f instanceof DecimalFormat) {
            ((DecimalFormat)f).setDecimalSeparatorAlwaysShown(true);
            fmt.setDecimalFormatSymbols(((DecimalFormat)f).getDecimalFormatSymbols());
        }
        String formatted = fmt.format(aValue);
        return formatted;
    }

    protected static String format(Calendar d) {
        if (d != null) {
            try {
                return DateFormatUtils.format((Date)d.getTime(), (String)"dd/MM/yyyy");
            }
            catch (Exception e) {
                log.log(Level.WARNING, "error formatting date", e);
            }
        }
        return "";
    }

    protected static String formatAccount(String a) {
        if (a != null) {
            StringBuilder result = new StringBuilder(a);
            try {
                result.insert(4, '-');
                result.insert(9, '-');
                result.insert(12, '-');
                return result.toString();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "error formatting account", e);
            }
        }
        return "";
    }

    protected void appendInLines(StringBuilder sb, String ... lines) {
        Validate.notNull((Object)sb);
        if (lines == null) {
            log.finest("lines is null");
        } else {
            for (int i = 0; i < lines.length; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)lines[i])) continue;
                if (i != 0 || i == 0 && StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    sb.append("\r\n");
                }
                sb.append(lines[i]);
            }
        }
    }

    protected void appendInLines(StringBuilder sb, int componentStart, int componentEnd) {
        Validate.notNull((Object)sb);
        boolean first = true;
        for (int i = componentStart; i <= componentEnd; ++i) {
            String c = this.getComponent(i);
            if (!StringUtils.isNotBlank((CharSequence)c)) continue;
            if (!first || StringUtils.isNotBlank((CharSequence)sb.toString())) {
                sb.append("\r\n");
            }
            sb.append(c);
            first = false;
        }
    }

    public List<String> getComponents() {
        return this.components;
    }

    public void setComponents(List<String> components) {
        this.components = components;
    }

    public void setComponent(int number, String value) {
        Validate.isTrue((number > 0 ? 1 : 0) != 0, (String)"component number is 1-based", (Object[])new Object[0]);
        int position = number - 1;
        if (this.components == null) {
            this.components = new ArrayList<String>();
        }
        if (position >= 0) {
            if (position >= this.components.size()) {
                log.warning("component number " + number + " is out of bound for field " + this.getName());
            } else {
                this.components.set(position, value);
            }
        } else {
            log.severe("components are named starting at 1, cannot insert a component with number " + number);
        }
    }

    public String getComponent(int number) {
        int position = number - 1;
        if (this.components != null && position >= 0 && position < this.components.size()) {
            return this.components.get(position);
        }
        return null;
    }

    public String getValueDisplay() {
        return this.getValueDisplay(null);
    }

    public String getValueDisplay(Locale locale) {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i <= this.components.size(); ++i) {
            String s = this.getValueDisplay(i, locale);
            if (s == null) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(s);
        }
        return result.toString();
    }

    public abstract String getValueDisplay(int var1, Locale var2);

    public Object getComponentAs(int component, Class c) {
        try {
            String s = this.getComponent(component);
            log.finest("converting string value: " + s);
            if (c.equals(String.class)) {
                return s;
            }
            if (c.equals(Number.class) || c.equals(BigDecimal.class)) {
                return SwiftFormatUtils.getNumber(s);
            }
            if (c.equals(BIC.class)) {
                return new BIC(s);
            }
            if (c.equals(Currency.class)) {
                return Currency.getInstance(s);
            }
            if (c.equals(Character.class)) {
                return SwiftFormatUtils.getSign(s);
            }
            if (c.equals(Integer.class)) {
                return Integer.valueOf(s);
            }
            throw new IllegalArgumentException("Can't handle " + c.getName());
        }
        catch (Exception e) {
            log.severe("Error converting component content: " + e);
            return null;
        }
    }

    public Number getComponentAsNumber(int component) {
        return (Number)this.getComponentAs(component, Number.class);
    }

    public String joinComponents(int start, boolean skipLast) {
        ArrayList<String> toAdd = new ArrayList<String>();
        for (int i = start; i < this.componentsSize(); ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)this.components.get(i))) continue;
            toAdd.add(this.components.get(i));
        }
        int end = skipLast ? toAdd.size() - 1 : toAdd.size();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < end; ++i) {
            result.append((String)toAdd.get(i));
        }
        return result.toString();
    }

    public String joinComponents(boolean skipLast) {
        return this.joinComponents(0, skipLast);
    }

    public String joinComponents(int start) {
        return this.joinComponents(start, false);
    }

    public String joinComponents() {
        return this.joinComponents(0, false);
    }

    public static BigDecimal getAsBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof Short) {
            return new BigDecimal(((Short)number).intValue());
        }
        if (number instanceof Double) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("class " + number.getClass().getName() + " is not supported");
    }

    public String findComponentStartingWith(String prefix) {
        for (int i = 0; i < this.components.size(); ++i) {
            String c = this.components.get(i);
            if (!StringUtils.startsWith((CharSequence)c, (CharSequence)prefix)) continue;
            return c;
        }
        return null;
    }

    public String getValueByCodeword(String codeword) {
        String key = "/" + codeword + "/";
        String c = this.findComponentStartingWith(key);
        if (c != null) {
            return StringUtils.substringAfter((String)c, (String)key);
        }
        return null;
    }

    public abstract String getValue();

    public boolean isEmpty() {
        for (String c : this.getComponents()) {
            if (c == null || !StringUtils.isNotBlank((CharSequence)c)) continue;
            return false;
        }
        return true;
    }

    public static Field getField(Tag t) {
        return Field.getField(t.getName(), t.getValue());
    }

    public static Field getField(String name, String value) {
        Object r = null;
        try {
            Class<?> c = Class.forName("com.prowidesoftware.swift.model.field.Field" + name);
            Class[] argsClass = new Class[]{String.class};
            Constructor<?> ct = c.getConstructor(argsClass);
            Object[] arglist = new Object[]{value};
            r = ct.newInstance(arglist);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.WARNING, "Field class for Field" + name + " not found. This is normally caused by an unrecognized field in the message or a malformed message block structure.", e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "An error occured while creating an instance of " + name, e);
        }
        return r;
    }

    @Deprecated
    public String getLabel() {
        DeprecationUtils.phase3(Field.class, "getLabel()", "This method uses deprecated label property files. Use getLabel(String, String, String, Locale.getDefault())} with proper MT and sequence identifiers instead.");
        return this.getLabel(Locale.getDefault());
    }

    @Deprecated
    public String getLabel(Locale locale) {
        DeprecationUtils.phase3(Field.class, "getLabel(Locale)", "This method uses deprecated label property files. Use getLabel(String, String, String, Locale)} with proper MT and sequence identifiers instead.");
        return Field.getLabel(this.getName(), locale);
    }

    @Deprecated
    public static String getLabel(String fieldName, Locale locale) {
        DeprecationUtils.phase3(Field.class, "getLabel(String, Locale)", "This method uses deprecated label property files. Use getLabel(String, String, String, Locale)} with proper MT and sequence identifiers instead.");
        return Field._getLabel(fieldName, null, null, locale);
    }

    @Deprecated
    private static String _getLabel(String fieldName, String mt, String sequence, Locale locale) {
        String bundle = "deprecated_labels";
        String key = null;
        String result = null;
        ResourceBundle labels = ResourceBundle.getBundle("deprecated_labels", locale);
        if (labels != null) {
            if (sequence != null && mt != null && (result = Field.getString(labels, key = "field" + fieldName + "[" + mt + "][" + sequence + "].name")) == null) {
                key = "field" + Field.getNumber(fieldName) + "a[" + mt + "][" + sequence + "].name";
                result = Field.getString(labels, key);
            }
            if (result == null && mt != null && (result = Field.getString(labels, key = "field" + fieldName + "[" + mt + "][" + sequence + "].name")) == null) {
                key = "field" + Field.getNumber(fieldName) + "a[" + mt + "].name";
                result = Field.getString(labels, key);
            }
            if (result == null && (result = Field.getString(labels, key = "field" + fieldName + ".name")) == null) {
                key = "field" + Field.getNumber(fieldName) + "a.name";
                result = Field.getString(labels, key);
            }
            if (result == null) {
                key = "field" + Field.getNumber(fieldName) + ".name";
                result = Field.getString(labels, key);
            }
        }
        if (result != null) {
            return result;
        }
        return key;
    }

    public static String getLabel(String fieldName, String mt, String sequence) {
        return Field.getLabel(fieldName, mt, sequence, Locale.getDefault());
    }

    public static String getLabel(String fieldName, String mt, String sequence, Locale locale) {
        return Field._getLabel(fieldName, mt, sequence, locale, "name");
    }

    public static String getLabelComponents(String fieldName, String mt, String sequence, Locale locale) {
        Locale l = locale != null ? locale : Locale.getDefault();
        return Field._getLabel(fieldName, mt, sequence, l, "components");
    }

    private static String _getLabel(String fieldName, String mt, String sequence, Locale locale, String prop) {
        String bundle = "pw_swift_labels";
        String key = null;
        String result = null;
        ResourceBundle labels = ResourceBundle.getBundle("pw_swift_labels", locale);
        if (labels != null) {
            if (sequence != null && mt != null && (result = Field.getString(labels, key = "field" + fieldName + "[" + mt + "][" + sequence + "]." + prop)) == null) {
                key = "field" + Field.getNumber(fieldName) + "a[" + mt + "][" + sequence + "]." + prop;
                result = Field.getString(labels, key);
            }
            if (result == null && mt != null && (result = Field.getString(labels, key = "field" + fieldName + "[" + mt + "]." + prop)) == null) {
                key = "field" + Field.getNumber(fieldName) + "a[" + mt + "]." + prop;
                result = Field.getString(labels, key);
            }
            if (result == null && (result = Field.getString(labels, key = "field" + fieldName + "." + prop)) == null) {
                key = "field" + Field.getNumber(fieldName) + "a." + prop;
                result = Field.getString(labels, key);
            }
            if (result == null) {
                key = "field" + Field.getNumber(fieldName) + "." + prop;
                result = Field.getString(labels, key);
            }
        }
        if (result != null) {
            return result;
        }
        return key;
    }

    private static String getString(ResourceBundle labels, String key) {
        try {
            return labels.getString(key);
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    private static String getNumber(String fieldName) {
        if (fieldName != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < fieldName.length(); ++i) {
                char c = fieldName.charAt(i);
                if (!Character.isDigit(c)) continue;
                sb.append(c);
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }

    public abstract String getName();

    @Override
    public abstract String componentsPattern();

    public abstract String validatorPattern();

    public abstract boolean isOptional(int var1);

    public abstract boolean isGeneric();

    @Deprecated
    public String getDSS() {
        return null;
    }

    @Deprecated
    public boolean isDSSPresent() {
        return false;
    }

    @Deprecated
    public String getConditionalQualifier() {
        return null;
    }

    public Character letterOption() {
        String cn = this.getClass().getName();
        char c = cn.charAt(cn.length() - 1);
        if (Character.isLetter(c)) {
            return Character.valueOf(c);
        }
        return null;
    }

    public boolean isLetterOption(char c) {
        Character l = this.letterOption();
        if (l != null) {
            return l.charValue() == c;
        }
        return false;
    }

    @Deprecated
    public boolean isAnyOf(String ... names) {
        DeprecationUtils.phase2(this.getClass(), "isAnyOf(String...)", "Use isNameAnyOf(String...) instead.");
        return this.isNameAnyOf(names);
    }

    public boolean isNameAnyOf(String ... names) {
        Validate.isTrue((names != null && names.length > 0 ? 1 : 0) != 0, (String)"name list must have at least one element", (Object[])new Object[0]);
        for (String n : names) {
            if (!StringUtils.equals((CharSequence)this.getName(), (CharSequence)n)) continue;
            return true;
        }
        return false;
    }

    public boolean is(String compare) {
        return StringUtils.equals((CharSequence)compare, (CharSequence)this.getComponent(1));
    }

    public boolean is(int componentNumber, String compare) {
        return StringUtils.equals((CharSequence)compare, (CharSequence)this.getComponent(componentNumber));
    }

    public boolean is(String compare1, String compare2) {
        return StringUtils.equals((CharSequence)compare1, (CharSequence)this.getComponent(1)) && StringUtils.equals((CharSequence)compare2, (CharSequence)this.getComponent(2));
    }

    public boolean is(String ... values) {
        String comp1 = this.getComponent(1);
        if (values != null) {
            for (String value : values) {
                if (!StringUtils.equals((CharSequence)comp1, (CharSequence)value)) continue;
                return true;
            }
        }
        return false;
    }

    public Tag asTag() {
        return new Tag(this.getName(), this.getValue());
    }

    public abstract int componentsSize();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getLine(Field cp, Integer start, Integer end, int offset) {
        boolean removeSeparators;
        String hash = UUID.randomUUID().toString();
        for (int i = 1; i <= this.componentsSize(); ++i) {
            if (i < offset) {
                cp.setComponent(i, null);
                continue;
            }
            if (this.getComponent(i) != null) continue;
            cp.setComponent(i, hash);
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String l : SwiftParseUtils.getLines(cp.getValue())) {
            if (!StringUtils.isNotEmpty((CharSequence)l) || this.onlySlashes(l)) continue;
            lines.add(l);
        }
        boolean bl = removeSeparators = offset > 0;
        if (start == null) return this.asString(hash, lines, removeSeparators);
        if (lines.size() < start) return null;
        if (end == null) return this.clean(hash, (String)lines.get(start - 1), removeSeparators);
        if (end >= start) {
            Integer trimmedEnd = end;
            if (end <= lines.size()) return this.asString(hash, lines.subList(start - 1, trimmedEnd), removeSeparators);
            trimmedEnd = lines.size() - 1;
            return this.asString(hash, lines.subList(start - 1, trimmedEnd), removeSeparators);
        }
        log.warning("invalid lines range [" + start + "-" + end + "] the ending line number (" + end + ") must be greater or equal to the starting line number (" + start + ")");
        return null;
    }

    private boolean onlySlashes(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '/') continue;
            return false;
        }
        return true;
    }

    private String asString(String hash, List<String> list, boolean removeSeparators) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            boolean b;
            String l = list.get(i);
            String trimmed = this.clean(hash, l, b = i == 0 ? removeSeparators : false);
            if (trimmed == null) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(trimmed);
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    private String clean(String hash, String value, boolean removeSeparators) {
        String trimmed = StringUtils.trimToNull((String)StringUtils.replace((String)StringUtils.replace((String)value, (String)("/" + hash), (String)""), (String)hash, (String)""));
        if (trimmed != null && !this.onlySlashes(trimmed)) {
            if (trimmed.startsWith("://")) {
                return StringUtils.substringAfter((String)trimmed, (String)"://");
            }
            if (removeSeparators && (trimmed.startsWith(":") || trimmed.startsWith("/"))) {
                return StringUtils.trimToNull((String)StringUtils.substring((String)trimmed, (int)1));
            }
            return trimmed;
        }
        return null;
    }

    public static boolean validName(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() < 2 || name.length() > 3) {
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)name.substring(0, 2))) {
            return false;
        }
        return name.length() != 3 || Character.isDigit(name.charAt(2)) || name.charAt(2) == 'a' || Character.isUpperCase(name.charAt(2));
    }

    protected abstract List<String> getComponentLabels();

    public String getComponentLabel(int number) {
        int position = number - 1;
        List<String> labels = this.getComponentLabels();
        if (labels != null && position >= 0 && position < labels.size()) {
            return labels.get(position);
        }
        return null;
    }

    protected abstract Map<Integer, String> getComponentMap();

    private String getComponentLabelCamelCase(int number) {
        Map<Integer, String> labels = this.getComponentMap();
        if (labels != null && number >= 0) {
            return labels.get(number);
        }
        return null;
    }

    protected final Locale notNull(Locale locale) {
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    protected void append(StringBuilder result, int component) {
        String value = this.getComponent(component);
        if (value != null && result != null) {
            result.append(value);
        }
    }

    @Override
    public String toJson() {
        JsonObject field = new JsonObject();
        field.addProperty("name", this.getName());
        for (int i = 1; i <= this.getComponents().size(); ++i) {
            if (this.getComponent(i) == null) continue;
            String label = this.getComponentLabelCamelCase(i);
            if (label == null) {
                label = "value";
            }
            field.addProperty(label, this.getComponent(i));
        }
        return field.toString();
    }

    public static Field fromJson(String json) {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        JsonElement nameElement = jsonObject.get("name");
        if (nameElement != null) {
            String name = nameElement.getAsString();
            Object r = null;
            try {
                Class<?> c = Class.forName("com.prowidesoftware.swift.model.field.Field" + name);
                Method method = c.getMethod("fromJson", String.class);
                return (Field)method.invoke(null, json);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.WARNING, "Field class for Field" + name + " not found. This is normally caused by an unrecognized field in the message or a malformed message block structure.", e);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "An error occured while creating an instance of " + name, e);
            }
            return r;
        }
        return null;
    }
}

