/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field255
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "255";
    public static final String F_255 = "255";
    public static final String PARSER_PATTERN = "<LT>4!N<MT><DATE2>[<HHMM><HHMM>]";
    public static final String COMPONENTS_PATTERN = "ZNMEHH";
    public static final Integer LT_ADDRESS = 1;
    public static final Integer SESSION_NUMBER = 2;
    public static final Integer MESSAGE_TYPE = 3;
    public static final Integer DATE = 4;
    public static final Integer START_TIME = 5;
    public static final Integer END_TIME = 6;

    public Field255() {
        super(6);
    }

    public Field255(String value) {
        super(value);
    }

    public Field255(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"255")) {
            throw new IllegalArgumentException("cannot create field 255 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(6);
        if (value != null) {
            if (value.length() >= 12) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)12));
            }
            if (value.length() >= 16) {
                this.setComponent2(StringUtils.substring((String)value, (int)12, (int)16));
            }
            if (value.length() >= 19) {
                this.setComponent3(StringUtils.substring((String)value, (int)16, (int)19));
            }
            if (value.length() >= 25) {
                this.setComponent4(StringUtils.substring((String)value, (int)19, (int)25));
            }
            if (value.length() >= 29) {
                this.setComponent5(StringUtils.substring((String)value, (int)25, (int)29));
            }
            if (value.length() > 29) {
                this.setComponent6(StringUtils.substring((String)value, (int)29));
            }
        }
    }

    public static Field255 newInstance(Field255 source) {
        Field255 cp = new Field255();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        this.append(result, 4);
        this.append(result, 5);
        this.append(result, 6);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("255", value);
    }

    public static Tag emptyTag() {
        return new Tag("255", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public LogicalTerminalAddress getComponent1AsLogicalTerminalAddress() {
        return SwiftFormatUtils.getLTAddress(this.getComponent(1));
    }

    public String getLTAddress() {
        return this.getComponent(1);
    }

    public LogicalTerminalAddress getLTAddressAsLogicalTerminalAddress() {
        return SwiftFormatUtils.getLTAddress(this.getComponent(1));
    }

    public Field255 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field255 setComponent1(LogicalTerminalAddress component1) {
        this.setComponent(1, SwiftFormatUtils.getLTAddress(component1));
        return this;
    }

    public Field255 setLTAddress(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field255 setLTAddress(LogicalTerminalAddress component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getSessionNumber() {
        return this.getComponent(2);
    }

    public Number getSessionNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field255 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field255 setComponent2(Number component2) {
        if (component2 != null) {
            this.setComponent(2, Integer.toString(component2.intValue()));
        }
        return this;
    }

    public Field255 setSessionNumber(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field255 setSessionNumber(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getMessageType() {
        return this.getComponent(3);
    }

    public Field255 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field255 setMessageType(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(4));
    }

    public String getDate() {
        return this.getComponent(4);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(4));
    }

    public Field255 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field255 setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getDate2(component4));
        return this;
    }

    public Field255 setDate(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field255 setDate(Calendar component4) {
        this.setComponent4(component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Calendar getComponent5AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(5));
    }

    public String getStartTime() {
        return this.getComponent(5);
    }

    public Calendar getStartTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(5));
    }

    public Field255 setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field255 setComponent5(Calendar component5) {
        this.setComponent(5, SwiftFormatUtils.getTime3(component5));
        return this;
    }

    public Field255 setStartTime(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field255 setStartTime(Calendar component5) {
        this.setComponent5(component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Calendar getComponent6AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(6));
    }

    public String getEndTime() {
        return this.getComponent(6);
    }

    public Calendar getEndTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(6));
    }

    public Field255 setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field255 setComponent6(Calendar component6) {
        this.setComponent(6, SwiftFormatUtils.getTime3(component6));
        return this;
    }

    public Field255 setEndTime(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field255 setEndTime(Calendar component6) {
        this.setComponent6(component6);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(4)));
        result.add(SwiftFormatUtils.getTime3(this.getComponent(5)));
        result.add(SwiftFormatUtils.getTime3(this.getComponent(6)));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "255";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<LT>4!n<MT><DATE2>[<HHMM><HHMM>]";
    }

    public static Field255 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("255");
        if (t == null) {
            return null;
        }
        return new Field255(t);
    }

    public static Field255 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field255.get(msg.getBlock4());
    }

    public static List<Field255> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field255.getAll(msg.getBlock4());
    }

    public static List<Field255> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("255");
        if (arr != null && arr.length > 0) {
            ArrayList<Field255> result = new ArrayList<Field255>(arr.length);
            for (Tag f : arr) {
                result.add(new Field255(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        Format f;
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 255");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            Number n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 5) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent5AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 6) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent6AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("LT Address");
        result.add("Session Number");
        result.add("Message Type");
        result.add("Date");
        result.add("Start Time");
        result.add("End Time");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "lTAddress");
        result.put(2, "sessionNumber");
        result.put(3, "messageType");
        result.put(4, "date");
        result.put(5, "startTime");
        result.put(6, "endTime");
        return result;
    }

    public static Field255 fromJson(String json) {
        Field255 field = new Field255();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("lTAddress") != null) {
            field.setComponent1(jsonObject.get("lTAddress").getAsString());
        }
        if (jsonObject.get("sessionNumber") != null) {
            field.setComponent2(jsonObject.get("sessionNumber").getAsString());
        }
        if (jsonObject.get("messageType") != null) {
            field.setComponent3(jsonObject.get("messageType").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent4(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("startTime") != null) {
            field.setComponent5(jsonObject.get("startTime").getAsString());
        }
        if (jsonObject.get("endTime") != null) {
            field.setComponent6(jsonObject.get("endTime").getAsString());
        }
        return field;
    }
}

