/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field33J
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "33J";
    public static final String F_33J = "33J";
    public static final String PARSER_PATTERN = "SN";
    public static final String COMPONENTS_PATTERN = "SN";
    public static final Integer CURRENCY = 1;
    public static final Integer AMOUNT = 2;

    public Field33J() {
        super(2);
    }

    public Field33J(String value) {
        super(value);
    }

    public Field33J(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"33J")) {
            throw new IllegalArgumentException("cannot create field 33J from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    public static Field33J newInstance(Field33J source) {
        Field33J cp = new Field33J();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("33J", value);
    }

    public static Tag emptyTag() {
        return new Tag("33J", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getCurrency() {
        return this.getComponent(1);
    }

    public Field33J setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field33J setCurrency(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getAmount() {
        return this.getComponent(2);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field33J setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field33J setComponent2(Number component2) {
        this.setComponent(2, SwiftFormatUtils.getNumber(component2));
        return this;
    }

    public Field33J setAmount(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field33J setAmount(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return "SN";
    }

    @Override
    public String getName() {
        return "33J";
    }

    @Override
    public final String componentsPattern() {
        return "SN";
    }

    @Override
    public final String validatorPattern() {
        return "3!a<AMOUNT>15";
    }

    public static Field33J get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("33J");
        if (t == null) {
            return null;
        }
        return new Field33J(t);
    }

    public static Field33J get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field33J.get(msg.getBlock4());
    }

    public static List<Field33J> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field33J.getAll(msg.getBlock4());
    }

    public static List<Field33J> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("33J");
        if (arr != null && arr.length > 0) {
            ArrayList<Field33J> result = new ArrayList<Field33J>(arr.length);
            for (Tag f : arr) {
                result.add(new Field33J(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 33J");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "currency");
        result.put(2, "amount");
        return result;
    }

    public static Field33J fromJson(String json) {
        Field33J field = new Field33J();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("currency") != null) {
            field.setComponent1(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent2(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

