/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field102;
import com.prowidesoftware.swift.model.field.Field104;
import com.prowidesoftware.swift.model.field.Field106;
import com.prowidesoftware.swift.model.field.Field108;
import com.prowidesoftware.swift.model.field.Field431;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT010
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT010.class.getName());
    public static final String NAME = "010";
    @Deprecated
    public static final String N = "N";
    @Deprecated
    public static final String S = "S";
    @Deprecated
    public static final String U = "U";

    public MT010(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT010(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT010 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT010(m);
    }

    public MT010() {
        this("TESTUS00", "TESTUS00");
    }

    public MT010(String sender, String receiver) {
        super(10, sender, receiver);
    }

    @Deprecated
    public MT010(int messageType, String sender, String receiver) {
        super(10, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT010(int, String, String)", "Use the constructor MT010(sender, receiver) instead.");
    }

    public MT010(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT010.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT010 object from FIN content with a Service Message. Check if the MT010 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT010 object from FIN content with message type " + param.getType());
        }
    }

    public static MT010 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT010(fin);
    }

    public MT010(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT010 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT010(stream);
    }

    public MT010(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT010 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT010(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT010 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT010 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT010 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT010 fromJson(String json) {
        return (MT010)AbstractMT.fromJson(json);
    }

    public Field106 getField106() {
        Tag t = this.tag("106");
        if (t != null) {
            return new Field106(t.getValue());
        }
        return null;
    }

    public Field108 getField108() {
        Tag t = this.tag("108");
        if (t != null) {
            return new Field108(t.getValue());
        }
        return null;
    }

    public Field431 getField431() {
        Tag t = this.tag("431");
        if (t != null) {
            return new Field431(t.getValue());
        }
        return null;
    }

    public Field102 getField102() {
        Tag t = this.tag("102");
        if (t != null) {
            return new Field102(t.getValue());
        }
        return null;
    }

    public Field104 getField104() {
        Tag t = this.tag("104");
        if (t != null) {
            return new Field104(t.getValue());
        }
        return null;
    }
}

