/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field174;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT045
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT045.class.getName());
    public static final String NAME = "045";

    public MT045(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT045(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT045 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT045(m);
    }

    public MT045() {
        this("TESTUS00", "TESTUS00");
    }

    public MT045(String sender, String receiver) {
        super(45, sender, receiver);
    }

    @Deprecated
    public MT045(int messageType, String sender, String receiver) {
        super(45, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT045(int, String, String)", "Use the constructor MT045(sender, receiver) instead.");
    }

    public MT045(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT045.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT045 object from FIN content with a Service Message. Check if the MT045 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT045 object from FIN content with message type " + param.getType());
        }
    }

    public static MT045 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT045(fin);
    }

    public MT045(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT045 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT045(stream);
    }

    public MT045(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT045 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT045(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT045 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT045 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT045 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT045 fromJson(String json) {
        return (MT045)AbstractMT.fromJson(json);
    }

    public Field174 getField174() {
        Tag t = this.tag("174");
        if (t != null) {
            return new Field174(t.getValue());
        }
        return null;
    }
}

