/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT048
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT048.class.getName());
    public static final String NAME = "048";

    public MT048(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT048(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT048 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT048(m);
    }

    public MT048() {
        this("TESTUS00", "TESTUS00");
    }

    public MT048(String sender, String receiver) {
        super(48, sender, receiver);
    }

    @Deprecated
    public MT048(int messageType, String sender, String receiver) {
        super(48, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT048(int, String, String)", "Use the constructor MT048(sender, receiver) instead.");
    }

    public MT048(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT048.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT048 object from FIN content with a Service Message. Check if the MT048 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT048 object from FIN content with message type " + param.getType());
        }
    }

    public static MT048 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT048(fin);
    }

    public MT048(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT048 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT048(stream);
    }

    public MT048(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT048 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT048(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT048 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT048 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT048 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT048 fromJson(String json) {
        return (MT048)AbstractMT.fromJson(json);
    }
}

