/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt2xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field19;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field56A;
import com.prowidesoftware.swift.model.field.Field56D;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57B;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT201
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT201.class.getName());
    public static final String NAME = "201";

    public MT201(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT201(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT201 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT201(m);
    }

    public MT201() {
        this("TESTUS00", "TESTUS00");
    }

    public MT201(String sender, String receiver) {
        super(201, sender, receiver);
    }

    @Deprecated
    public MT201(int messageType, String sender, String receiver) {
        super(201, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT201(int, String, String)", "Use the constructor MT201(sender, receiver) instead.");
    }

    public MT201(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT201.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT201 object from FIN content with a Service Message. Check if the MT201 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT201 object from FIN content with message type " + param.getType());
        }
    }

    public static MT201 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT201(fin);
    }

    public MT201(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT201 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT201(stream);
    }

    public MT201(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT201 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT201(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT201 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT201 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT201 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT201 fromJson(String json) {
        return (MT201)AbstractMT.fromJson(json);
    }

    public Field19 getField19() {
        Tag t = this.tag("19");
        if (t != null) {
            return new Field19(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public List<Field20> getField20() {
        ArrayList<Field20> result = new ArrayList<Field20>();
        Tag[] tags = this.tags("20");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field56A> getField56A() {
        ArrayList<Field56A> result = new ArrayList<Field56A>();
        Tag[] tags = this.tags("56A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field56A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field56D> getField56D() {
        ArrayList<Field56D> result = new ArrayList<Field56D>();
        Tag[] tags = this.tags("56D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field56D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57A> getField57A() {
        ArrayList<Field57A> result = new ArrayList<Field57A>();
        Tag[] tags = this.tags("57A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57B> getField57B() {
        ArrayList<Field57B> result = new ArrayList<Field57B>();
        Tag[] tags = this.tags("57B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57D> getField57D() {
        ArrayList<Field57D> result = new ArrayList<Field57D>();
        Tag[] tags = this.tags("57D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field72> getField72() {
        ArrayList<Field72> result = new ArrayList<Field72>();
        Tag[] tags = this.tags("72");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field72(tag.getValue()));
            }
        }
        return result;
    }
}

