/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field13A;
import com.prowidesoftware.swift.model.field.Field13B;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.field.Field16S;
import com.prowidesoftware.swift.model.field.Field20C;
import com.prowidesoftware.swift.model.field.Field23G;
import com.prowidesoftware.swift.model.field.Field25D;
import com.prowidesoftware.swift.model.field.Field95L;
import com.prowidesoftware.swift.model.field.Field95P;
import com.prowidesoftware.swift.model.field.Field95Q;
import com.prowidesoftware.swift.model.field.Field95R;
import com.prowidesoftware.swift.model.field.Field98A;
import com.prowidesoftware.swift.model.field.Field98C;
import com.prowidesoftware.swift.model.field.Field98E;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT517
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT517.class.getName());
    public static final String NAME = "517";
    @Deprecated
    public static final String AFFM = "AFFM";
    @Deprecated
    public static final String ALTE = "ALTE";
    @Deprecated
    public static final String BASK = "BASK";
    @Deprecated
    public static final String BUYR = "BUYR";
    @Deprecated
    public static final String CANC = "CANC";
    @Deprecated
    public static final String CODU = "CODU";
    @Deprecated
    public static final String COLR = "COLR";
    @Deprecated
    public static final String COMM = "COMM";
    @Deprecated
    public static final String COPY = "COPY";
    @Deprecated
    public static final String DEAG = "DEAG";
    @Deprecated
    public static final String DUPL = "DUPL";
    @Deprecated
    public static final String GENL = "GENL";
    @Deprecated
    public static final String INDX = "INDX";
    @Deprecated
    public static final String ISSU = "ISSU";
    @Deprecated
    public static final String LINK = "LINK";
    @Deprecated
    public static final String LIST = "LIST";
    @Deprecated
    public static final String MAST = "MAST";
    @Deprecated
    public static final String NEWM = "NEWM";
    @Deprecated
    public static final String PREP = "PREP";
    @Deprecated
    public static final String PREV = "PREV";
    @Deprecated
    public static final String PROG = "PROG";
    @Deprecated
    public static final String REAG = "REAG";
    @Deprecated
    public static final String RELA = "RELA";
    @Deprecated
    public static final String SELL = "SELL";
    @Deprecated
    public static final String SEME = "SEME";
    @Deprecated
    public static final String TRRF = "TRRF";

    public MT517(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT517(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT517 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT517(m);
    }

    public MT517() {
        this("TESTUS00", "TESTUS00");
    }

    public MT517(String sender, String receiver) {
        super(517, sender, receiver);
    }

    @Deprecated
    public MT517(int messageType, String sender, String receiver) {
        super(517, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT517(int, String, String)", "Use the constructor MT517(sender, receiver) instead.");
    }

    public MT517(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT517.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT517 object from FIN content with a Service Message. Check if the MT517 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT517 object from FIN content with message type " + param.getType());
        }
    }

    public static MT517 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT517(fin);
    }

    public MT517(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT517 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT517(stream);
    }

    public MT517(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT517 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT517(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT517 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT517 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT517 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT517 fromJson(String json) {
        return (MT517)AbstractMT.fromJson(json);
    }

    public Field23G getField23G() {
        Tag t = this.tag("23G");
        if (t != null) {
            return new Field23G(t.getValue());
        }
        return null;
    }

    public Field98A getField98A() {
        Tag t = this.tag("98A");
        if (t != null) {
            return new Field98A(t.getValue());
        }
        return null;
    }

    public Field98C getField98C() {
        Tag t = this.tag("98C");
        if (t != null) {
            return new Field98C(t.getValue());
        }
        return null;
    }

    public Field98E getField98E() {
        Tag t = this.tag("98E");
        if (t != null) {
            return new Field98E(t.getValue());
        }
        return null;
    }

    public Field25D getField25D() {
        Tag t = this.tag("25D");
        if (t != null) {
            return new Field25D(t.getValue());
        }
        return null;
    }

    public List<Field95L> getField95L() {
        ArrayList<Field95L> result = new ArrayList<Field95L>();
        Tag[] tags = this.tags("95L");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95L(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95P> getField95P() {
        ArrayList<Field95P> result = new ArrayList<Field95P>();
        Tag[] tags = this.tags("95P");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95P(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95Q> getField95Q() {
        ArrayList<Field95Q> result = new ArrayList<Field95Q>();
        Tag[] tags = this.tags("95Q");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95Q(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95R> getField95R() {
        ArrayList<Field95R> result = new ArrayList<Field95R>();
        Tag[] tags = this.tags("95R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16R> getField16R() {
        ArrayList<Field16R> result = new ArrayList<Field16R>();
        Tag[] tags = this.tags("16R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13A> getField13A() {
        ArrayList<Field13A> result = new ArrayList<Field13A>();
        Tag[] tags = this.tags("13A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13B> getField13B() {
        ArrayList<Field13B> result = new ArrayList<Field13B>();
        Tag[] tags = this.tags("13B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field20C> getField20C() {
        ArrayList<Field20C> result = new ArrayList<Field20C>();
        Tag[] tags = this.tags("20C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16S> getField16S() {
        ArrayList<Field16S> result = new ArrayList<Field16S>();
        Tag[] tags = this.tags("16S");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16S(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return new SequenceA(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        SequenceA s = new SequenceA();
        s.setTags(parentSequence.getSubBlock(GENL).getTags());
        return s;
    }

    public List<SequenceA1> getSequenceA1List() {
        return MT517.getSequenceA1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceA1> getSequenceA1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks = parentSequence.getSubBlocks(LINK);
        if (blocks != null && !blocks.isEmpty()) {
            ArrayList<SequenceA1> result = new ArrayList<SequenceA1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceA1 s = new SequenceA1();
                s.setTags(b.getSubBlock(LINK).getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceA1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LINK";
        public static final Tag START_TAG = new Tag("16R", "LINK");
        public static final Tag END_TAG = new Tag("16S", "LINK");

        private SequenceA1() {
            super(new ArrayList<Tag>());
        }

        private SequenceA1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA1 newInstance(Tag ... tags) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance() {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock("LINK").getTags());
            }
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "GENL";
        public static final Tag START_TAG = new Tag("16R", "GENL");
        public static final Tag END_TAG = new Tag("16S", "GENL");

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock("GENL").getTags());
            }
        }
    }
}

