/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field13D;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field25P;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT900
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT900.class.getName());
    public static final String NAME = "900";

    public MT900(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT900(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT900 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT900(m);
    }

    public MT900() {
        this("TESTUS00", "TESTUS00");
    }

    public MT900(String sender, String receiver) {
        super(900, sender, receiver);
    }

    @Deprecated
    public MT900(int messageType, String sender, String receiver) {
        super(900, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT900(int, String, String)", "Use the constructor MT900(sender, receiver) instead.");
    }

    public MT900(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT900.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT900 object from FIN content with a Service Message. Check if the MT900 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT900 object from FIN content with message type " + param.getType());
        }
    }

    public static MT900 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT900(fin);
    }

    public MT900(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT900 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT900(stream);
    }

    public MT900(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT900 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT900(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT900 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT900 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT900 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT900 fromJson(String json) {
        return (MT900)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field25P getField25P() {
        Tag t = this.tag("25P");
        if (t != null) {
            return new Field25P(t.getValue());
        }
        return null;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field13D getField13D() {
        Tag t = this.tag("13D");
        if (t != null) {
            return new Field13D(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }
}

