/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import java.util.Arrays;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class IsoUtils {
    private static final transient Logger log = Logger.getLogger(IsoUtils.class.getName());
    private Set<String> currencies = new HashSet<String>();
    private Set<String> countries;
    private static IsoUtils instance;

    private IsoUtils() {
        for (Locale locale : Locale.getAvailableLocales()) {
            try {
                String val = Currency.getInstance(locale).getCurrencyCode();
                if (this.currencies.contains(val)) continue;
                this.currencies.add(val);
            }
            catch (Exception e) {
                log.log(Level.FINEST, "error loading currencies from locale " + locale, e);
            }
        }
        this.countries = new HashSet<String>(Arrays.asList(Locale.getISOCountries()));
        this.addCountry("XK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized IsoUtils getInstance() {
        if (instance != null) return instance;
        Class<IsoUtils> clazz = IsoUtils.class;
        synchronized (IsoUtils.class) {
            if (instance != null) return instance;
            instance = new IsoUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Set<String> getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(Set<String> currencies) {
        this.currencies = currencies;
    }

    public Set<String> getCountries() {
        return this.countries;
    }

    public void setCountries(Set<String> countries) {
        this.countries = countries;
    }

    public boolean isValidISOCurrency(String currencyCode) {
        if (StringUtils.length((CharSequence)currencyCode) == 3) {
            return this.currencies.contains(currencyCode);
        }
        return false;
    }

    public boolean isValidISOCountry(String countryCode) {
        if (StringUtils.length((CharSequence)countryCode) == 2) {
            return this.countries.contains(countryCode);
        }
        return false;
    }

    public void addCountry(String countryCode) {
        Validate.isTrue((countryCode != null && countryCode.length() == 2 && countryCode.matches("[A-Z]*") ? 1 : 0) != 0, (String)"The country code must by indicated with two uppercase letters", (Object[])new Object[0]);
        if (!this.countries.contains(countryCode)) {
            this.countries.add(countryCode);
        }
    }

    public void addCurrency(String currencyCode) {
        Validate.isTrue((currencyCode != null && currencyCode.length() == 3 && currencyCode.matches("[A-Z]*") ? 1 : 0) != 0, (String)"The currency code must by indicated with three uppercase letters", (Object[])new Object[0]);
        if (!this.currencies.contains(currencyCode)) {
            this.currencies.add(currencyCode);
        }
    }
}

