/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class Lib {
    private Lib() {
    }

    public static String readFile(String filename) throws IOException {
        return Lib.readFile(new File(filename));
    }

    public static String readFile(File file) throws IOException {
        return Lib.readFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String encoding) throws IOException {
        if (!(file != null && file.exists() && file.canRead() && file.isFile())) {
            return null;
        }
        String charset = encoding != null ? encoding : "UTF-8";
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        StringBuilder sb = new StringBuilder((int)file.length());
        try {
            int c = 0;
            while ((c = in.read()) != -1) {
                sb.append((char)c);
            }
        }
        finally {
            in.close();
        }
        return sb.toString();
    }

    public static String readResource(String resource) throws IOException {
        return Lib.readResource(resource, null);
    }

    public static String readResource(String resource, String encoding) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (is == null) {
            return "";
        }
        return Lib.readStream(is, null);
    }

    public static String readStream(InputStream stream) throws IOException {
        return Lib.readStream(stream, null);
    }

    public static String readStream(InputStream stream, String enconding) throws IOException {
        if (stream == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        String enc = enconding != null ? enconding : "UTF-8";
        try (InputStreamReader in = new InputStreamReader(stream, enc);){
            int c = 0;
            while ((c = ((Reader)in).read()) != -1) {
                out.append((char)c);
            }
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readReader(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        try {
            int c = 0;
            while ((c = reader.read()) != -1) {
                out.append((char)c);
            }
        }
        finally {
            reader.close();
        }
        return out.toString();
    }
}

