/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.writer;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.model.SwiftBlock;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.IMessageVisitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class XMLWriterVisitor
implements IMessageVisitor {
    private static final transient Logger log = Logger.getLogger(XMLWriterVisitor.class.getName());
    private static final String EOL = System.getProperties().getProperty("line.separator", "\n");
    private Writer writer;
    private boolean useField;

    public XMLWriterVisitor(Writer writer) {
        this.writer = writer;
    }

    public XMLWriterVisitor(Writer writer, boolean useField) {
        this.writer = writer;
        this.useField = useField;
    }

    @Override
    public void startMessage(SwiftMessage m) {
        this.write("<message>");
    }

    @Override
    public void endMessage(SwiftMessage m) {
        if (m.getUnparsedTextsSize() > 0) {
            this.write(m.getUnparsedTexts(), 0);
        }
        this.write(EOL + "</message>");
    }

    @Override
    public void startBlock1(SwiftBlock1 b) {
        this.write(EOL + "<block1>");
    }

    @Override
    public void value(SwiftBlock1 b, String v) {
        StringBuilder sb = new StringBuilder();
        if (!b.isEmpty()) {
            this.appendElement(sb, "applicationId", b.getApplicationId());
            this.appendElement(sb, "serviceId", b.getServiceId());
            this.appendElement(sb, "logicalTerminal", b.getLogicalTerminal());
            if (b.getSessionNumber() != null) {
                this.appendElement(sb, "sessionNumber", b.getSessionNumber());
            }
            if (b.getSequenceNumber() != null) {
                this.appendElement(sb, "sequenceNumber", b.getSequenceNumber());
            }
            this.write(sb.toString());
        }
    }

    @Override
    public void endBlock1(SwiftBlock1 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block1>");
    }

    @Override
    public void startBlock2(SwiftBlock2 b) {
        String xmlTag = "<block2>";
        if (!b.isEmpty()) {
            if (b instanceof SwiftBlock2Input) {
                xmlTag = "<block2 type=\"input\">";
            }
            if (b instanceof SwiftBlock2Output) {
                xmlTag = "<block2 type=\"output\">";
            }
        }
        this.write(EOL + xmlTag);
    }

    @Override
    public void value(SwiftBlock2 b, String v) {
        SwiftBlock2 b2;
        if (StringUtils.isEmpty((CharSequence)v)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (b instanceof SwiftBlock2Input) {
            b2 = (SwiftBlock2Input)b;
            this.appendElement(sb, "messageType", ((SwiftBlock2Input)b2).getMessageType());
            this.appendElement(sb, "receiverAddress", ((SwiftBlock2Input)b2).getReceiverAddress());
            if (((SwiftBlock2Input)b2).getMessagePriority() != null) {
                this.appendElement(sb, "messagePriority", ((SwiftBlock2Input)b2).getMessagePriority());
            }
            if (((SwiftBlock2Input)b2).getDeliveryMonitoring() != null) {
                this.appendElement(sb, "deliveryMonitoring", ((SwiftBlock2Input)b2).getDeliveryMonitoring());
            }
            if (((SwiftBlock2Input)b2).getObsolescencePeriod() != null) {
                this.appendElement(sb, "obsolescencePeriod", ((SwiftBlock2Input)b2).getObsolescencePeriod());
            }
        }
        if (b instanceof SwiftBlock2Output) {
            b2 = (SwiftBlock2Output)b;
            this.appendElement(sb, "messageType", b2.getMessageType());
            this.appendElement(sb, "senderInputTime", ((SwiftBlock2Output)b2).getSenderInputTime());
            this.appendElement(sb, "MIRDate", ((SwiftBlock2Output)b2).getMIRDate());
            this.appendElement(sb, "MIRLogicalTerminal", ((SwiftBlock2Output)b2).getMIRLogicalTerminal());
            this.appendElement(sb, "MIRSessionNumber", ((SwiftBlock2Output)b2).getMIRSessionNumber());
            this.appendElement(sb, "MIRSequenceNumber", ((SwiftBlock2Output)b2).getMIRSequenceNumber());
            this.appendElement(sb, "receiverOutputDate", ((SwiftBlock2Output)b2).getReceiverOutputDate());
            this.appendElement(sb, "receiverOutputTime", ((SwiftBlock2Output)b2).getReceiverOutputTime());
            if (b2.getMessagePriority() != null) {
                this.appendElement(sb, "messagePriority", b2.getMessagePriority());
            }
        }
        this.write(sb.toString());
    }

    @Override
    public void endBlock2(SwiftBlock2 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block2>");
    }

    @Override
    public void startBlock3(SwiftBlock3 b) {
        this.write(EOL + "<block3>");
    }

    @Override
    public void tag(SwiftBlock3 b, Tag t) {
        this.appendTag(t);
    }

    @Override
    public void endBlock3(SwiftBlock3 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block3>");
    }

    @Override
    public void startBlock4(SwiftBlock4 b) {
        this.write(EOL + "<block4>");
    }

    @Override
    public void tag(SwiftBlock4 b, Tag t) {
        if (this.useField) {
            this.appendField(t);
        } else {
            this.appendTag(t);
        }
    }

    @Override
    public void endBlock4(SwiftBlock4 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block4>");
    }

    @Override
    public void startBlock5(SwiftBlock5 b) {
        this.write(EOL + "<block5>");
    }

    @Override
    public void tag(SwiftBlock5 b, Tag t) {
        this.appendTag(t);
    }

    @Override
    public void endBlock5(SwiftBlock5 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block5>");
    }

    @Override
    public void startBlockUser(SwiftBlockUser b) {
        this.write(EOL + "<block name=\"" + b.getName() + "\">");
    }

    @Override
    public void tag(SwiftBlockUser b, Tag t) {
        this.appendTag(t);
    }

    @Override
    public void endBlockUser(SwiftBlockUser b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block>");
    }

    public void tag(SwiftBlock b, Tag t) {
        if (b == null) {
            return;
        }
        if (b instanceof SwiftBlock3) {
            this.tag((SwiftBlock3)b, t);
        }
        if (b instanceof SwiftBlock4) {
            this.tag((SwiftBlock4)b, t);
        }
        if (b instanceof SwiftBlock5) {
            this.tag((SwiftBlock5)b, t);
        }
        if (b instanceof SwiftBlockUser) {
            this.tag((SwiftBlockUser)b, t);
        }
    }

    private final void appendTag(Tag t) {
        this.write(EOL + "\t<tag>");
        this.write(EOL + "\t\t<name>");
        if (t.getName() != null) {
            this.write(t.getName());
        }
        this.write("</name>");
        this.write(EOL + "\t\t<value>");
        if (t.getValue() != null) {
            this.write(t.getValue());
        }
        this.write("</value>");
        if (t.getUnparsedTextsSize() > 0) {
            this.write(t.getUnparsedTexts(), 2);
        }
        this.write(EOL + "\t</tag>");
    }

    private void appendField(Tag tag) {
        if (tag == null) {
            return;
        }
        Field f = tag.asField();
        if (f != null) {
            this.write(EOL + "\t<field>");
            this.write(EOL + "\t\t<name>");
            if (f.getName() != null) {
                this.write(f.getName());
            }
            this.write("</name>");
            List<String> components = f.getComponents();
            for (int i = 0; i < components.size(); ++i) {
                int id = i + 1;
                String component = components.get(i);
                if (component == null) continue;
                this.write(EOL + "\t\t<component number=\"" + id + "\">");
                this.write(component);
                this.write("</component>");
            }
            this.write(EOL + "\t</field>");
        }
    }

    private final void appendElement(StringBuilder sb, String element, String value) {
        sb.append(EOL + "\t<").append(element).append('>').append(value).append("</").append(element).append('>');
    }

    private void write(UnparsedTextList texts, int level) {
        String prefix;
        switch (level) {
            case 0: {
                prefix = "";
                break;
            }
            case 2: {
                prefix = "\t\t";
                break;
            }
            default: {
                prefix = "\t";
            }
        }
        if (texts.size() > 0) {
            this.write(EOL + prefix + "<unparsedTexts>");
            for (int i = 0; i < texts.size(); ++i) {
                this.write(EOL + prefix + "\t<text>");
                this.write(texts.getText(i));
                this.write("</text>");
            }
            this.write(EOL + prefix + "</unparsedTexts>");
        }
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Caught exception in XMLWriterVisitor, method write", e);
            throw new ProwideException(e);
        }
    }
}

