/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.BIC;
import java.util.Objects;

public class LogicalTerminalAddress
extends BIC {
    private Character LTIdentifier;

    public LogicalTerminalAddress(String code) {
        super(code);
        if (code != null && code.length() >= 12) {
            this.LTIdentifier = Character.valueOf(code.charAt(8));
        }
    }

    public Character getLTIdentifier() {
        return this.LTIdentifier;
    }

    public void setLTIdentifier(Character lTIdentifier) {
        this.LTIdentifier = lTIdentifier;
    }

    public String getSenderLogicalTerminalAddress() {
        Character LT = Character.valueOf(this.LTIdentifier == null || this.LTIdentifier.equals(Character.valueOf('X')) ? (char)'A' : this.LTIdentifier.charValue());
        if (this.getBic8() != null) {
            return this.getBic8() + LT + this.getBranchOrDefault();
        }
        return null;
    }

    public String getReceiverLogicalTerminalAddress() {
        if (this.getBic8() != null) {
            return this.getBic8() + "X" + this.getBranchOrDefault();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogicalTerminalAddress that = (LogicalTerminalAddress)o;
        return Objects.equals(this.LTIdentifier, that.LTIdentifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.LTIdentifier);
    }
}

