/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import java.util.Calendar;
import java.util.Objects;
import java.util.logging.Logger;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;

@Entity
@Table(name="swift_msg_status")
public class SwiftMessageStatusInfo
implements Cloneable {
    private static final transient Logger log = Logger.getLogger(SwiftMessageStatusInfo.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(length=50)
    private String name;
    @Column(length=200)
    private String comments;
    @Column(name="creation_date")
    private Calendar creationDate = Calendar.getInstance();
    @Column(length=40, name="creation_user")
    private String creationUser;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private String data;

    public SwiftMessageStatusInfo() {
    }

    public SwiftMessageStatusInfo(String comments, Calendar creationDate, String creationUser, String name, String data) {
        this();
        this.comments = comments;
        this.creationDate = creationDate;
        this.creationUser = creationUser;
        this.name = name;
        this.data = data;
    }

    public SwiftMessageStatusInfo(String comments, Calendar creationDate, String creationUser, String name) {
        this(comments, creationUser, name, null);
        if (creationDate != null) {
            this.creationDate = creationDate;
        }
    }

    public SwiftMessageStatusInfo(String comments, String creationUser, String name, String data) {
        this(comments, Calendar.getInstance(), creationUser, name, data);
    }

    public SwiftMessageStatusInfo(String comments, String creationUser, String name) {
        this(comments, Calendar.getInstance(), creationUser, name, null);
    }

    public SwiftMessageStatusInfo(String comments, Calendar creationDate, String creationUser, Enum name) {
        this(comments, creationUser, name.name(), null);
        if (creationDate != null) {
            this.creationDate = creationDate;
        }
    }

    public SwiftMessageStatusInfo(String comments, String creationUser, Enum name, String data) {
        this(comments, Calendar.getInstance(), creationUser, name.name(), data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwiftMessageStatusInfo that = (SwiftMessageStatusInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.comments, that.comments) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.creationUser, that.creationUser);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comments, this.creationDate, this.creationUser);
    }

    public SwiftMessageStatusInfo(String comments, String creationUser, Enum name) {
        this(comments, Calendar.getInstance(), creationUser, name.name(), null);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public SwiftMessageStatusInfo setName(String name) {
        this.name = name;
        return this;
    }

    public String getComments() {
        return this.comments;
    }

    public SwiftMessageStatusInfo setComments(String comments) {
        this.comments = comments;
        return this;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public SwiftMessageStatusInfo setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public String getCreationUser() {
        return this.creationUser;
    }

    public SwiftMessageStatusInfo setCreationUser(String creationUser) {
        this.creationUser = creationUser;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public SwiftMessageStatusInfo setData(String data) {
        this.data = data;
        return this;
    }

    public String toString() {
        return this.name;
    }

    public Object clone() {
        SwiftMessageStatusInfo result = new SwiftMessageStatusInfo();
        result.setComments(this.getComments());
        result.setCreationDate(this.getCreationDate());
        result.setCreationUser(this.getCreationUser());
        result.setData(this.getData());
        result.setId(this.getId());
        result.setName(this.getName());
        return result;
    }
}

