/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field41A
extends Field
implements Serializable,
BICContainer,
MultiLineField {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "41A";
    public static final String F_41A = "41A";
    public static final String PARSER_PATTERN = "S$S";
    public static final String COMPONENTS_PATTERN = "BS";
    public static final Integer BIC = 1;
    public static final Integer CODE = 2;

    public Field41A() {
        super(2);
    }

    public Field41A(String value) {
        super(value);
    }

    public Field41A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"41A")) {
            throw new IllegalArgumentException("cannot create field 41A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(lines.get(0));
            if (lines.size() > 1) {
                this.setComponent2(lines.get(1));
            }
        }
    }

    public static Field41A newInstance(Field41A source) {
        Field41A cp = new Field41A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.appendInLines(result, 1, 2);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("41A", value);
    }

    public static Tag emptyTag() {
        return new Tag("41A", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public BIC getComponent1AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public String getBIC() {
        return this.getComponent(1);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public Field41A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field41A setComponent1(BIC component1) {
        this.setComponent(1, SwiftFormatUtils.getBIC(component1));
        return this;
    }

    public Field41A setBIC(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field41A setBIC(BIC component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getCode() {
        return this.getComponent(2);
    }

    public Field41A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field41A setCode(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> result = new ArrayList<BIC>();
        result.add(SwiftFormatUtils.getBIC(this.getComponent(1)));
        return result;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getComponent(1));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "41A";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<BIC>$14x";
    }

    public static Field41A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("41A");
        if (t == null) {
            return null;
        }
        return new Field41A(t);
    }

    public static Field41A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field41A.get(msg.getBlock4());
    }

    public static List<Field41A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field41A.getAll(msg.getBlock4());
    }

    public static List<Field41A> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("41A");
        if (arr != null && arr.length > 0) {
            ArrayList<Field41A> result = new ArrayList<Field41A>(arr.length);
            for (Tag f : arr) {
                result.add(new Field41A(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field41A cp = Field41A.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field41A cp = Field41A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field41A cp = Field41A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 41A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("BIC");
        result.add("Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "bIC");
        result.put(2, "code");
        return result;
    }

    public static Field41A fromJson(String json) {
        Field41A field = new Field41A();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("bIC") != null) {
            field.setComponent1(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent2(jsonObject.get("code").getAsString());
        }
        return field;
    }
}

