/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field48
extends Field
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "48";
    public static final String F_48 = "48";
    public static final String PARSER_PATTERN = "S[/S]";
    public static final String COMPONENTS_PATTERN = "NS";
    public static final Integer DAYS = 1;
    public static final Integer NARRATIVE = 2;

    public Field48() {
        super(2);
    }

    public Field48(String value) {
        super(value);
    }

    public Field48(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"48")) {
            throw new IllegalArgumentException("cannot create field 48 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
    }

    public static Field48 newInstance(Field48 source) {
        Field48 cp = new Field48();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("48", value);
    }

    public static Tag emptyTag() {
        return new Tag("48", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getDays() {
        return this.getComponent(1);
    }

    public Number getDaysAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public Field48 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field48 setComponent1(Number component1) {
        if (component1 != null) {
            this.setComponent(1, Integer.toString(component1.intValue()));
        }
        return this;
    }

    public Field48 setDays(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field48 setDays(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getNarrative() {
        return this.getComponent(2);
    }

    public Field48 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field48 setNarrative(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "48";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "3n[/35x]";
    }

    public static Field48 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("48");
        if (t == null) {
            return null;
        }
        return new Field48(t);
    }

    public static Field48 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field48.get(msg.getBlock4());
    }

    public static List<Field48> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field48.getAll(msg.getBlock4());
    }

    public static List<Field48> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("48");
        if (arr != null && arr.length > 0) {
            ArrayList<Field48> result = new ArrayList<Field48>(arr.length);
            for (Tag f : arr) {
                result.add(new Field48(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 48");
        }
        if (component == 1) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Days");
        result.add("Narrative");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "days");
        result.put(2, "narrative");
        return result;
    }

    public static Field48 fromJson(String json) {
        Field48 field = new Field48();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("days") != null) {
            field.setComponent1(jsonObject.get("days").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent2(jsonObject.get("narrative").getAsString());
        }
        return field;
    }
}

