/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field51A
extends Field
implements Serializable,
BICContainer,
MultiLineField {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "51A";
    public static final String F_51A = "51A";
    public static final String PARSER_PATTERN = "[[/c][/S]$]S";
    public static final String COMPONENTS_PATTERN = "SSB";
    public static final Integer DC_MARK = 1;
    public static final Integer ACCOUNT = 2;
    public static final Integer BIC = 3;

    public Field51A() {
        super(3);
    }

    public Field51A(String value) {
        super(value);
    }

    public Field51A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"51A")) {
            throw new IllegalArgumentException("cannot create field 51A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0).startsWith("/")) {
            String dcMark = SwiftParseUtils.getTokenFirst(lines.get(0), "/", "/");
            if (StringUtils.isNotEmpty((CharSequence)dcMark) && dcMark.length() == 1) {
                this.setComponent1(dcMark);
                this.setComponent2(SwiftParseUtils.getTokenSecondLast(StringUtils.substring((String)lines.get(0), (int)1), "/"));
            } else {
                this.setComponent2(StringUtils.substring((String)lines.get(0), (int)1));
            }
            if (lines.size() > 1) {
                this.setComponent3(lines.get(1));
            }
        } else {
            this.setComponent3(lines.get(0));
        }
    }

    public static Field51A newInstance(Field51A source) {
        Field51A cp = new Field51A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        if (this.getComponent3() != null) {
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(this.getComponent3());
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("51A", value);
    }

    public static Tag emptyTag() {
        return new Tag("51A", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field51A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field51A setDCMark(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getAccount() {
        String c = this.getComponent(2);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field51A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field51A setAccount(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BIC getComponent3AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(3));
    }

    public String getBIC() {
        return this.getComponent(3);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(3));
    }

    public Field51A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field51A setComponent3(BIC component3) {
        this.setComponent(3, SwiftFormatUtils.getBIC(component3));
        return this;
    }

    public Field51A setBIC(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field51A setBIC(BIC component3) {
        this.setComponent3(component3);
        return this;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> result = new ArrayList<BIC>();
        result.add(SwiftFormatUtils.getBIC(this.getComponent(3)));
        return result;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getComponent(3));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "51A";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[[/<DC>][/34x]$]<BIC>";
    }

    public static Field51A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("51A");
        if (t == null) {
            return null;
        }
        return new Field51A(t);
    }

    public static Field51A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field51A.get(msg.getBlock4());
    }

    public static List<Field51A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field51A.getAll(msg.getBlock4());
    }

    public static List<Field51A> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("51A");
        if (arr != null && arr.length > 0) {
            ArrayList<Field51A> result = new ArrayList<Field51A>(arr.length);
            for (Tag f : arr) {
                result.add(new Field51A(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field51A cp = Field51A.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field51A cp = Field51A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field51A cp = Field51A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 51A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Account");
        result.add("BIC");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "dCMark");
        result.put(2, "account");
        result.put(3, "bIC");
        return result;
    }

    public static Field51A fromJson(String json) {
        Field51A field = new Field51A();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("dCMark") != null) {
            field.setComponent1(jsonObject.get("dCMark").getAsString());
        }
        if (jsonObject.get("account") != null) {
            field.setComponent2(jsonObject.get("account").getAsString());
        }
        if (jsonObject.get("bIC") != null) {
            field.setComponent3(jsonObject.get("bIC").getAsString());
        }
        return field;
    }
}

