/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field58D
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "58D";
    public static final String F_58D = "58D";
    public static final String PARSER_PATTERN = "[[/c][/S]$]S[$S]0-3";
    public static final String COMPONENTS_PATTERN = "SSSSSS";
    public static final Integer DC_MARK = 1;
    public static final Integer ACCOUNT = 2;
    public static final Integer NAME_AND_ADDRESS = 3;

    public Field58D() {
        super(6);
    }

    public Field58D(String value) {
        super(value);
    }

    public Field58D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"58D")) {
            throw new IllegalArgumentException("cannot create field 58D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(6);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0).startsWith("/")) {
            String dcMark = SwiftParseUtils.getTokenFirst(lines.get(0), "/", "/");
            if (StringUtils.isNotEmpty((CharSequence)dcMark) && dcMark.length() == 1) {
                this.setComponent1(dcMark);
                this.setComponent2(SwiftParseUtils.getTokenSecondLast(StringUtils.substring((String)lines.get(0), (int)1), "/"));
            } else {
                this.setComponent2(StringUtils.substring((String)lines.get(0), (int)1));
            }
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 1, lines);
        } else {
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 0, lines);
        }
    }

    public static Field58D newInstance(Field58D source) {
        Field58D cp = new Field58D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        this.appendInLines(result, 3, 6);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("58D", value);
    }

    public static Tag emptyTag() {
        return new Tag("58D", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field58D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field58D setDCMark(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getAccount() {
        String c = this.getComponent(2);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field58D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field58D setAccount(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent3AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(3);
    }

    public String getNameAndAddressLine1() {
        return this.getComponent(3);
    }

    public String getNameAndAddressLine2() {
        return this.getComponent(4);
    }

    public String getNameAndAddressLine3() {
        return this.getComponent(5);
    }

    public String getNameAndAddressLine4() {
        return this.getComponent(6);
    }

    public String getNameAndAddress() {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < 7; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public Field58D setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field58D setNameAndAddressLine1(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field58D setNameAndAddressLine2(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field58D setNameAndAddressLine3(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field58D setNameAndAddressLine4(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field58D setNameAndAddress(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 3, 4, 0, lines);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent4AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(4);
    }

    public Field58D setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent5AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(5);
    }

    public Field58D setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    @Deprecated
    public String getComponent6AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent6AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(6);
    }

    public Field58D setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 2) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        return component == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "58D";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[[/<DC>][/34x]$]35x[$35x]0-3";
    }

    public static Field58D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("58D");
        if (t == null) {
            return null;
        }
        return new Field58D(t);
    }

    public static Field58D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field58D.get(msg.getBlock4());
    }

    public static List<Field58D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field58D.getAll(msg.getBlock4());
    }

    public static List<Field58D> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("58D");
        if (arr != null && arr.length > 0) {
            ArrayList<Field58D> result = new ArrayList<Field58D>(arr.length);
            for (Tag f : arr) {
                result.add(new Field58D(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field58D cp = Field58D.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field58D cp = Field58D.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field58D cp = Field58D.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 58D");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Account");
        result.add("Name And Address");
        result.add("Name And Address 2");
        result.add("Name And Address 3");
        result.add("Name And Address 4");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "dCMark");
        result.put(2, "account");
        result.put(3, "nameAndAddress");
        result.put(4, "nameAndAddress2");
        result.put(5, "nameAndAddress3");
        result.put(6, "nameAndAddress4");
        return result;
    }

    public static Field58D fromJson(String json) {
        Field58D field = new Field58D();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("dCMark") != null) {
            field.setComponent1(jsonObject.get("dCMark").getAsString());
        }
        if (jsonObject.get("account") != null) {
            field.setComponent2(jsonObject.get("account").getAsString());
        }
        if (jsonObject.get("nameAndAddress") != null) {
            field.setComponent3(jsonObject.get("nameAndAddress").getAsString());
        }
        if (jsonObject.get("nameAndAddress2") != null) {
            field.setComponent4(jsonObject.get("nameAndAddress2").getAsString());
        }
        if (jsonObject.get("nameAndAddress3") != null) {
            field.setComponent5(jsonObject.get("nameAndAddress3").getAsString());
        }
        if (jsonObject.get("nameAndAddress4") != null) {
            field.setComponent6(jsonObject.get("nameAndAddress4").getAsString());
        }
        return field;
    }

    @Deprecated
    public String getDC() {
        DeprecationUtils.phase2(this.getClass(), "getDC()", "Use use getDCMark() instead.");
        return this.getDCMark();
    }

    @Deprecated
    public void setDC(String DC) {
        DeprecationUtils.phase2(this.getClass(), "setDC(String)", "Use use setDCMark(String) instead.");
        this.setDCMark(DC);
    }
}

