/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field69F
extends Field
implements Serializable,
DateContainer,
GenericField {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "69F";
    public static final String F_69F = "69F";
    public static final String PARSER_PATTERN = ":S//S/<DATE4><TIME2>";
    public static final String COMPONENTS_PATTERN = "SSDT";
    public static final Integer QUALIFIER = 1;
    public static final Integer CODE = 2;
    public static final Integer DATE = 3;
    public static final Integer TIME = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field69F() {
        super(4);
    }

    public Field69F(String value) {
        super(value);
    }

    public Field69F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"69F")) {
            throw new IllegalArgumentException("cannot create field 69F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        String toparse2 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
        if (toparse2 != null) {
            if (toparse2.length() >= 8) {
                this.setComponent3(StringUtils.substring((String)toparse2, (int)0, (int)8));
            }
            if (toparse2.length() > 8) {
                this.setComponent4(StringUtils.substring((String)toparse2, (int)8));
            }
        }
    }

    public static Field69F newInstance(Field69F source) {
        Field69F cp = new Field69F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("69F", value);
    }

    public static Tag emptyTag() {
        return new Tag("69F", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field69F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field69F setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getCode() {
        return this.getComponent(2);
    }

    public Field69F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field69F setCode(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(3));
    }

    public String getDate() {
        return this.getComponent(3);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(3));
    }

    public Field69F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field69F setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getDate4(component3));
        return this;
    }

    public Field69F setDate(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field69F setDate(Calendar component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(4));
    }

    public String getTime() {
        return this.getComponent(4);
    }

    public Calendar getTimeAsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(4));
    }

    public Field69F setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field69F setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getTime2(component4));
        return this;
    }

    public Field69F setTime(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field69F setTime(Calendar component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(3)));
        result.add(SwiftFormatUtils.getTime2(this.getComponent(4)));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "69F";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//4!c/<DATE4><TIME2>";
    }

    public static Field69F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("69F");
        if (t == null) {
            return null;
        }
        return new Field69F(t);
    }

    public static Field69F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field69F.get(msg.getBlock4());
    }

    public static List<Field69F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field69F.getAll(msg.getBlock4());
    }

    public static List<Field69F> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("69F");
        if (arr != null && arr.length > 0) {
            ArrayList<Field69F> result = new ArrayList<Field69F>(arr.length);
            for (Tag f : arr) {
                result.add(new Field69F(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 69F");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 4) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Code");
        result.add("Date");
        result.add("Time");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "code");
        result.put(3, "date");
        result.put(4, "time");
        return result;
    }

    public static Field69F fromJson(String json) {
        Field69F field = new Field69F();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent2(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent3(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent4(jsonObject.get("time").getAsString());
        }
        return field;
    }
}

