/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field72
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "72";
    public static final String F_72 = "72";
    public static final String PARSER_PATTERN = "S[$S]0-5";
    public static final String COMPONENTS_PATTERN = "SSSSSS";
    public static final Integer NARRATIVE = 1;

    public Field72() {
        super(6);
    }

    public Field72(String value) {
        super(value);
    }

    public Field72(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"72")) {
            throw new IllegalArgumentException("cannot create field 72 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(6);
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, null, 0, lines);
    }

    public static Field72 newInstance(Field72 source) {
        Field72 cp = new Field72();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.appendInLines(result, 1, 6);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("72", value);
    }

    public static Tag emptyTag() {
        return new Tag("72", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getNarrativeLine1() {
        return this.getComponent(1);
    }

    public String getNarrativeLine2() {
        return this.getComponent(2);
    }

    public String getNarrativeLine3() {
        return this.getComponent(3);
    }

    public String getNarrativeLine4() {
        return this.getComponent(4);
    }

    public String getNarrativeLine5() {
        return this.getComponent(5);
    }

    public String getNarrativeLine6() {
        return this.getComponent(6);
    }

    public String getNarrative() {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < 7; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public Field72 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field72 setNarrativeLine1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field72 setNarrativeLine2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field72 setNarrativeLine3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field72 setNarrativeLine4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field72 setNarrativeLine5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field72 setNarrativeLine6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field72 setNarrative(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, 6, 0, lines);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public Field72 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent3AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(3);
    }

    public Field72 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent4AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(4);
    }

    public Field72 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent5AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(5);
    }

    public Field72 setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    @Deprecated
    public String getComponent6AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent6AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(6);
    }

    public Field72 setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        return component == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "72";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "CUSTOM";
    }

    public static Field72 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("72");
        if (t == null) {
            return null;
        }
        return new Field72(t);
    }

    public static Field72 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field72.get(msg.getBlock4());
    }

    public static List<Field72> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field72.getAll(msg.getBlock4());
    }

    public static List<Field72> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("72");
        if (arr != null && arr.length > 0) {
            ArrayList<Field72> result = new ArrayList<Field72>(arr.length);
            for (Tag f : arr) {
                result.add(new Field72(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field72 cp = Field72.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field72 cp = Field72.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field72 cp = Field72.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 72");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Narrative");
        result.add("Narrative 2");
        result.add("Narrative 3");
        result.add("Narrative 4");
        result.add("Narrative 5");
        result.add("Narrative 6");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "narrative");
        result.put(2, "narrative2");
        result.put(3, "narrative3");
        result.put(4, "narrative4");
        result.put(5, "narrative5");
        result.put(6, "narrative6");
        return result;
    }

    public static Field72 fromJson(String json) {
        Field72 field = new Field72();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("narrative") != null) {
            field.setComponent1(jsonObject.get("narrative").getAsString());
        }
        if (jsonObject.get("narrative2") != null) {
            field.setComponent2(jsonObject.get("narrative2").getAsString());
        }
        if (jsonObject.get("narrative3") != null) {
            field.setComponent3(jsonObject.get("narrative3").getAsString());
        }
        if (jsonObject.get("narrative4") != null) {
            field.setComponent4(jsonObject.get("narrative4").getAsString());
        }
        if (jsonObject.get("narrative5") != null) {
            field.setComponent5(jsonObject.get("narrative5").getAsString());
        }
        if (jsonObject.get("narrative6") != null) {
            field.setComponent6(jsonObject.get("narrative6").getAsString());
        }
        return field;
    }
}

