/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field92B
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer,
GenericField {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92B";
    public static final String F_92B = "92B";
    public static final String PARSER_PATTERN = ":S//S/S/N";
    public static final String COMPONENTS_PATTERN = "SCCN";
    public static final Integer QUALIFIER = 1;
    public static final Integer FIRST_CURRENCY_CODE = 2;
    public static final Integer SECOND_CURRENCY_CODE = 3;
    public static final Integer RATE = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field92B() {
        super(4);
    }

    public Field92B(String value) {
        super(value);
    }

    public Field92B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"92B")) {
            throw new IllegalArgumentException("cannot create field 92B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent3(SwiftParseUtils.getTokenSecond(toparse, "/"));
        this.setComponent4(SwiftParseUtils.getTokenThirdLast(toparse, "/"));
    }

    public static Field92B newInstance(Field92B source) {
        Field92B cp = new Field92B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("92B", value);
    }

    public static Tag emptyTag() {
        return new Tag("92B", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase2(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field92B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field92B setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getFirstCurrencyCode() {
        return this.getComponent(2);
    }

    public Currency getFirstCurrencyCodeAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field92B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92B setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field92B setFirstCurrencyCode(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92B setFirstCurrencyCode(Currency component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getSecondCurrencyCode() {
        return this.getComponent(3);
    }

    public Currency getSecondCurrencyCodeAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public Field92B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field92B setComponent3(Currency component3) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(component3));
        return this;
    }

    public Field92B setSecondCurrencyCode(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field92B setSecondCurrencyCode(Currency component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getRate() {
        return this.getComponent(4);
    }

    public Number getRateAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field92B setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field92B setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public Field92B setRate(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field92B setRate(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "92B";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<CUR>/<CUR>/<AMOUNT>15";
    }

    public static Field92B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("92B");
        if (t == null) {
            return null;
        }
        return new Field92B(t);
    }

    public static Field92B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field92B.get(msg.getBlock4());
    }

    public static List<Field92B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field92B.getAll(msg.getBlock4());
    }

    public static List<Field92B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("92B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field92B> result = new ArrayList<Field92B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field92B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 92B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("First Currency Code");
        result.add("Second Currency Code");
        result.add("Rate");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "firstCurrencyCode");
        result.put(3, "secondCurrencyCode");
        result.put(4, "rate");
        return result;
    }

    public static Field92B fromJson(String json) {
        Field92B field = new Field92B();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("firstCurrencyCode") != null) {
            field.setComponent2(jsonObject.get("firstCurrencyCode").getAsString());
        }
        if (jsonObject.get("secondCurrencyCode") != null) {
            field.setComponent3(jsonObject.get("secondCurrencyCode").getAsString());
        }
        if (jsonObject.get("rate") != null) {
            field.setComponent4(jsonObject.get("rate").getAsString());
        }
        return field;
    }
}

