/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class AbstractMTAdapter
implements JsonSerializer<AbstractMT>,
JsonDeserializer<AbstractMT> {
    private static final String BLOCK1_FINAL_NAME = "basicHeaderBlock";
    private static final String BLOCK2_FINAL_NAME = "applicationHeaderBlock";
    private static final String BLOCK3_FINAL_NAME = "userHeaderBlock";
    private static final String BLOCK4_FINAL_NAME = "textBlock";
    private static final String BLOCK5_FINAL_NAME = "trailerBlock";

    public JsonElement serialize(AbstractMT src, Type typeOfSrc, JsonSerializationContext context) {
        String json = src.m.toJson();
        JsonParser parser = new JsonParser();
        JsonObject o = parser.parse(json).getAsJsonObject();
        JsonObject response = new JsonObject();
        response.addProperty("type", "MT");
        if (src.m.getBlock1() != null) {
            response.add(BLOCK1_FINAL_NAME, o.get("data").getAsJsonObject().get("block1"));
        }
        if (src.m.getBlock2() != null) {
            response.add(BLOCK2_FINAL_NAME, o.get("data").getAsJsonObject().get("block2"));
        }
        if (src.m.getBlock3() != null && !src.m.getBlock3().getTags().isEmpty()) {
            this.setFinalBlockNameAndFields(response, "block3", src.m.getBlock3().getTags());
        }
        if (src.m.getBlock4() != null && !src.m.getBlock4().getTags().isEmpty()) {
            this.setFinalBlockNameAndFields(response, "block4", src.m.getBlock4().getTags());
        }
        if (src.m.getBlock5() != null && !src.m.getBlock5().getTags().isEmpty()) {
            JsonArray tags = o.get("data").getAsJsonObject().get("block5").getAsJsonObject().get("tags").getAsJsonArray();
            JsonObject trailer = new JsonObject();
            trailer.add("fields", (JsonElement)tags);
            response.add(BLOCK5_FINAL_NAME, (JsonElement)trailer);
        }
        return response;
    }

    public AbstractMT deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonElement fields;
        JsonElement trailerBlock;
        JsonElement fields2;
        JsonElement textBlock;
        JsonElement fields3;
        JsonElement userHeaderBlock;
        SwiftBlock2 block2;
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        SwiftMessage swiftMessage = new SwiftMessage();
        SwiftBlock1 block1 = (SwiftBlock1)jsonDeserializationContext.deserialize(jsonObject.get(BLOCK1_FINAL_NAME), SwiftBlock1.class);
        if (block1 != null) {
            swiftMessage.addBlock(block1);
        }
        if ((block2 = (SwiftBlock2)jsonDeserializationContext.deserialize(jsonObject.get(BLOCK2_FINAL_NAME), SwiftBlock2.class)) != null) {
            swiftMessage.addBlock(block2);
        }
        if ((userHeaderBlock = jsonObject.get(BLOCK3_FINAL_NAME)) != null && (fields3 = userHeaderBlock.getAsJsonObject().get("fields")) != null) {
            SwiftBlock3 block3 = new SwiftBlock3();
            block3 = (SwiftBlock3)this.setFieldsOnBlock(fields3, block3);
            swiftMessage.addBlock(block3);
        }
        if ((textBlock = jsonObject.get(BLOCK4_FINAL_NAME)) != null && (fields2 = textBlock.getAsJsonObject().get("fields")) != null) {
            SwiftBlock4 block4 = new SwiftBlock4();
            block4 = (SwiftBlock4)this.setFieldsOnBlock(fields2, block4);
            swiftMessage.addBlock(block4);
        }
        if ((trailerBlock = jsonObject.get(BLOCK5_FINAL_NAME)) != null && (fields = trailerBlock.getAsJsonObject().get("fields")) != null) {
            SwiftBlock5 block5 = new SwiftBlock5();
            for (JsonElement element : fields.getAsJsonArray()) {
                Tag tag = new Tag();
                tag.setName(element.getAsJsonObject().get("name").getAsString());
                JsonElement valueElement = element.getAsJsonObject().get("value");
                if (valueElement != null) {
                    tag.setValue(valueElement.getAsString());
                }
                block5.append(tag);
            }
            swiftMessage.addBlock(block5);
        }
        return swiftMessage.toMT();
    }

    private SwiftTagListBlock setFieldsOnBlock(JsonElement fields, SwiftTagListBlock block) {
        for (Field field : AbstractMTAdapter.parseFields(fields)) {
            block.append(field);
        }
        return block;
    }

    private static List<Field> parseFields(JsonElement fieldsElement) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (JsonElement element : fieldsElement.getAsJsonArray()) {
            Field field = Field.fromJson(element.toString());
            if (field == null) continue;
            fields.add(field);
        }
        return fields;
    }

    private void setFinalBlockNameAndFields(JsonObject response, String blockName, List<Tag> tags) {
        String finalBlockName = BLOCK4_FINAL_NAME;
        if (blockName.equals("block3")) {
            finalBlockName = BLOCK3_FINAL_NAME;
        } else if (blockName.equals("block5")) {
            finalBlockName = BLOCK5_FINAL_NAME;
        }
        JsonArray fields = this.getFieldsFromTags(tags);
        JsonObject block = new JsonObject();
        block.add("fields", (JsonElement)fields);
        response.add(finalBlockName, (JsonElement)block);
    }

    private JsonArray getFieldsFromTags(List<Tag> tags) {
        JsonArray fields = new JsonArray();
        JsonParser parser = new JsonParser();
        for (Tag tag : tags) {
            String json = tag.asField().toJson();
            JsonObject jsonObj = parser.parse(json).getAsJsonObject();
            fields.add((JsonElement)jsonObj);
        }
        return fields;
    }
}

