/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.Validate;

public class ServiceMessage21
extends AbstractMT {
    public ServiceMessage21(SwiftMessage aMessage) {
        super(aMessage);
        Validate.isTrue((boolean)aMessage.isServiceMessage21());
    }

    public ServiceMessage21(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public ServiceMessage21(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public ServiceMessage21(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = ServiceMessage21.read(fin)) != null) {
            this.m = parsed;
            Validate.isTrue((boolean)parsed.isServiceMessage21());
        }
    }

    public static AbstractMT newInstance(SwiftMessage swiftMessage) {
        return new ServiceMessage21(swiftMessage);
    }

    public static ServiceMessage21 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new ServiceMessage21(m.message());
    }

    public static ServiceMessage21 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new ServiceMessage21(stream);
    }

    public static ServiceMessage21 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new ServiceMessage21(file);
    }

    public static ServiceMessage21 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new ServiceMessage21(fin);
    }

    @Override
    public String getMessageType() {
        return null;
    }

    public final boolean isAck() {
        return this.m.isAck();
    }

    public final boolean isNack() {
        return this.m.isNack();
    }

    public String getErrorCode() {
        Tag t = this.m.getBlock4().getTagByName("405");
        if (t == null) {
            return null;
        }
        return t.asField().getComponent(1);
    }

    public String getErrorLine() {
        Tag t = this.m.getBlock4().getTagByName("405");
        if (t == null) {
            return null;
        }
        return t.asField().getComponent(2);
    }
}

