/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt2xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field56A;
import com.prowidesoftware.swift.model.field.Field56D;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57B;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT200
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT200.class.getName());
    public static final String NAME = "200";

    public MT200(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT200(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT200 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT200(m);
    }

    public MT200() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT200(String sender, String receiver) {
        super(200, sender, receiver);
    }

    @Deprecated
    public MT200(int messageType, String sender, String receiver) {
        super(200, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT200(int, String, String)", "Use the constructor MT200(sender, receiver) instead.");
    }

    public MT200(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT200.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT200 object from FIN content with a Service Message. Check if the MT200 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT200 object from FIN content with message type " + param.getType());
        }
    }

    public static MT200 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT200(fin);
    }

    public MT200(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT200 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT200(stream);
    }

    public MT200(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT200 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT200(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT200 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT200 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT200 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT200 fromJson(String json) {
        return (MT200)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public Field56A getField56A() {
        Tag t = this.tag("56A");
        if (t != null) {
            return new Field56A(t.getValue());
        }
        return null;
    }

    public Field56D getField56D() {
        Tag t = this.tag("56D");
        if (t != null) {
            return new Field56D(t.getValue());
        }
        return null;
    }

    public Field57A getField57A() {
        Tag t = this.tag("57A");
        if (t != null) {
            return new Field57A(t.getValue());
        }
        return null;
    }

    public Field57B getField57B() {
        Tag t = this.tag("57B");
        if (t != null) {
            return new Field57B(t.getValue());
        }
        return null;
    }

    public Field57D getField57D() {
        Tag t = this.tag("57D");
        if (t != null) {
            return new Field57D(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }
}

