/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field33A;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field53D;
import com.prowidesoftware.swift.model.field.Field54A;
import com.prowidesoftware.swift.model.field.Field54B;
import com.prowidesoftware.swift.model.field.Field54D;
import com.prowidesoftware.swift.model.field.Field71D;
import com.prowidesoftware.swift.model.field.Field72Z;
import com.prowidesoftware.swift.model.field.Field79Z;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT752
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT752.class.getName());
    public static final String NAME = "752";

    public MT752(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT752(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT752 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT752(m);
    }

    public MT752() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT752(String sender, String receiver) {
        super(752, sender, receiver);
    }

    @Deprecated
    public MT752(int messageType, String sender, String receiver) {
        super(752, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT752(int, String, String)", "Use the constructor MT752(sender, receiver) instead.");
    }

    public MT752(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT752.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT752 object from FIN content with a Service Message. Check if the MT752 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT752 object from FIN content with message type " + param.getType());
        }
    }

    public static MT752 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT752(fin);
    }

    public MT752(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT752 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT752(stream);
    }

    public MT752(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT752 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT752(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT752 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT752 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT752 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT752 fromJson(String json) {
        return (MT752)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field23 getField23() {
        Tag t = this.tag("23");
        if (t != null) {
            return new Field23(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field71D getField71D() {
        Tag t = this.tag("71D");
        if (t != null) {
            return new Field71D(t.getValue());
        }
        return null;
    }

    public Field33A getField33A() {
        Tag t = this.tag("33A");
        if (t != null) {
            return new Field33A(t.getValue());
        }
        return null;
    }

    public Field33B getField33B() {
        Tag t = this.tag("33B");
        if (t != null) {
            return new Field33B(t.getValue());
        }
        return null;
    }

    public Field53A getField53A() {
        Tag t = this.tag("53A");
        if (t != null) {
            return new Field53A(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public Field53D getField53D() {
        Tag t = this.tag("53D");
        if (t != null) {
            return new Field53D(t.getValue());
        }
        return null;
    }

    public Field54A getField54A() {
        Tag t = this.tag("54A");
        if (t != null) {
            return new Field54A(t.getValue());
        }
        return null;
    }

    public Field54B getField54B() {
        Tag t = this.tag("54B");
        if (t != null) {
            return new Field54B(t.getValue());
        }
        return null;
    }

    public Field54D getField54D() {
        Tag t = this.tag("54D");
        if (t != null) {
            return new Field54D(t.getValue());
        }
        return null;
    }

    public Field72Z getField72Z() {
        Tag t = this.tag("72Z");
        if (t != null) {
            return new Field72Z(t.getValue());
        }
        return null;
    }

    public Field79Z getField79Z() {
        Tag t = this.tag("79Z");
        if (t != null) {
            return new Field79Z(t.getValue());
        }
        return null;
    }
}

