/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field12;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field34F;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT920
extends AbstractMT
implements Serializable {
    public static final int SRU = 2018;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT920.class.getName());
    public static final String NAME = "920";
    @Deprecated
    public static final String _940 = "940";
    @Deprecated
    public static final String _941 = "941";
    @Deprecated
    public static final String _942 = "942";
    @Deprecated
    public static final String _950 = "950";

    public MT920(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT920(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT920 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT920(m);
    }

    public MT920() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT920(String sender, String receiver) {
        super(920, sender, receiver);
    }

    @Deprecated
    public MT920(int messageType, String sender, String receiver) {
        super(920, sender, receiver);
        DeprecationUtils.phase3(this.getClass(), "MT920(int, String, String)", "Use the constructor MT920(sender, receiver) instead.");
    }

    public MT920(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT920.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT920 object from FIN content with a Service Message. Check if the MT920 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT920 object from FIN content with message type " + param.getType());
        }
    }

    public static MT920 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT920(fin);
    }

    public MT920(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT920 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT920(stream);
    }

    public MT920(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT920 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT920(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT920 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT920 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT920 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT920 fromJson(String json) {
        return (MT920)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public List<Field12> getField12() {
        ArrayList<Field12> result = new ArrayList<Field12>();
        Tag[] tags = this.tags("12");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field12(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field25> getField25() {
        ArrayList<Field25> result = new ArrayList<Field25>();
        Tag[] tags = this.tags("25");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field25(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field34F> getField34F() {
        ArrayList<Field34F> result = new ArrayList<Field34F>();
        Tag[] tags = this.tags("34F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field34F(tag.getValue()));
            }
        }
        return result;
    }
}

