/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import java.lang.reflect.Type;

class AbstractMXAdapter
implements JsonSerializer<AbstractMX>,
JsonDeserializer<AbstractMX> {
    private static final String IDENTIFIER = "identifier";

    AbstractMXAdapter() {
    }

    public JsonElement serialize(AbstractMX mx, Type type, JsonSerializationContext context) {
        JsonObject object = context.serialize((Object)mx).getAsJsonObject();
        object.addProperty("@xmlns", mx.getNamespace());
        object.addProperty(IDENTIFIER, mx.getMxId().id());
        return object;
    }

    public AbstractMX deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get(IDENTIFIER);
        if (prim == null) {
            throw new JsonParseException("Missing identifier in JSON structure");
        }
        MxId id = new MxId(prim.getAsString());
        Class<?> klass = null;
        try {
            String className = "com.prowidesoftware.swift.model.mx.Mx" + id.camelized();
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException("Cannot find MX implementation for " + e.getMessage());
        }
        return (AbstractMX)context.deserialize(json, klass);
    }
}

