/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class XmlEventWriter
implements XMLEventWriter {
    private static final transient Logger log = Logger.getLogger(XmlEventWriter.class.getName());
    private Writer out;
    private final StringBuilder indent = new StringBuilder();
    private StartElement delayedStart = null;
    private boolean startTagIncomplete = false;
    private int startElementCount;
    private String defaultPrefix = null;
    private Map<String, String> peferredPrefixes;
    private boolean includeXMLDeclaration = true;
    private String rootElement = null;

    public XmlEventWriter(Writer baos, String defaultPrefix, boolean includeXMLDeclaration, String rootElement) {
        this.out = baos;
        this.startElementCount = 0;
        this.defaultPrefix = defaultPrefix;
        this.includeXMLDeclaration = includeXMLDeclaration;
        this.rootElement = rootElement;
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        if (event != null) {
            try {
                int type = event.getEventType();
                switch (type) {
                    case 7: {
                        if (this.includeXMLDeclaration) {
                            this.out.write("<?xml version=\"1.0\" encoding=\"" + ((StartDocument)event).getCharacterEncodingScheme() + "\"?>");
                            break;
                        }
                        log.finest("skipping xml declaration");
                        break;
                    }
                    case 1: {
                        ++this.startElementCount;
                        this.closeStartTagIfNeeded();
                        this.indent.append(' ');
                        StartElement se = event.asStartElement();
                        if (StringUtils.equals((CharSequence)se.getName().getLocalPart(), (CharSequence)this.rootElement) && this.startElementCount == 1) {
                            this.delayedStart = se;
                            log.finest("local part is Document, initializing delayed start, startElementCount=" + this.startElementCount);
                            break;
                        }
                        this.out.write("\n" + this.indent + "<" + this.prefix(se.getName()) + se.getName().getLocalPart());
                        this.startTagIncomplete = true;
                        break;
                    }
                    case 13: {
                        Namespace ne = (Namespace)event;
                        StringBuilder sb = new StringBuilder();
                        if (this.delayedStart != null) {
                            sb.append("\n" + this.indent + "<" + this.prefix(ne.getName()) + this.delayedStart.getName().getLocalPart());
                            this.delayedStart = null;
                        }
                        sb.append(this.namespace(ne));
                        this.out.write(sb.toString());
                        this.startTagIncomplete = true;
                        break;
                    }
                    case 4: {
                        this.closeStartTagIfNeeded();
                        Characters ce = event.asCharacters();
                        char[] arr = ce.getData().toCharArray();
                        this.out.write(this.escape(arr));
                        break;
                    }
                    case 2: {
                        this.closeStartTagIfNeeded();
                        this.indent.deleteCharAt(0);
                        EndElement ee = event.asEndElement();
                        this.out.write("</" + this.prefix(ee.getName()) + ee.getName().getLocalPart() + ">\n" + this.indent);
                        break;
                    }
                    case 8: {
                        this.closeStartTagIfNeeded();
                        break;
                    }
                    case 10: {
                        Attribute a = (Attribute)event;
                        this.out.write(" " + a.getName() + "=\"" + a.getValue() + "\" ");
                        break;
                    }
                    default: {
                        log.finer("PW Unhandled XMLEvent " + ToStringBuilder.reflectionToString((Object)event));
                        break;
                    }
                }
            }
            catch (IOException e) {
                log.severe("PW I/O error: " + e.getMessage());
                log.log(Level.FINER, "PW I/O error: ", e);
                throw new XMLStreamException(e);
            }
        }
    }

    private String namespace(Namespace ne) {
        StringBuilder sb = new StringBuilder(" xmlns");
        String prefix = null;
        if (this.peferredPrefixes != null) {
            prefix = this.peferredPrefixes.get(ne.getValue());
        }
        if (prefix == null && this.defaultPrefix != null) {
            prefix = this.defaultPrefix;
        }
        if (prefix != null) {
            sb.append(":").append(prefix);
        }
        sb.append("=\"").append(ne.getValue()).append("\"");
        return sb.toString();
    }

    private String escape(char[] arr) {
        StringBuilder sb = new StringBuilder(arr.length);
        block6: for (int i = 0; i < arr.length; ++i) {
            switch (arr[i]) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append('\"');
                    continue block6;
                }
                default: {
                    if (arr[i] > '\u007f') {
                        sb.append("&#");
                        sb.append(Integer.toString(arr[i]));
                        sb.append(';');
                        continue block6;
                    }
                    sb.append(arr[i]);
                }
            }
        }
        return sb.toString();
    }

    private String peferredPrefix(QName qname) {
        String prefix;
        if (this.peferredPrefixes != null && (prefix = this.peferredPrefixes.get(qname.getNamespaceURI())) != null) {
            return prefix;
        }
        if (this.defaultPrefix != null) {
            return this.defaultPrefix;
        }
        return null;
    }

    private String prefix(QName qname) {
        String prefix = this.peferredPrefix(qname);
        if (prefix != null) {
            return prefix + ":";
        }
        return "";
    }

    private void closeStartTagIfNeeded() throws IOException {
        if (this.startTagIncomplete) {
            this.out.write(62);
            this.startTagIncomplete = false;
        }
    }

    @Override
    public void add(XMLEventReader arg0) throws XMLStreamException {
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new ProwideNamespaceContext();
    }

    @Override
    public String getPrefix(String arg0) throws XMLStreamException {
        return null;
    }

    @Override
    public void setDefaultNamespace(String arg0) throws XMLStreamException {
    }

    @Override
    public void setNamespaceContext(NamespaceContext arg0) throws XMLStreamException {
    }

    @Override
    public void setPrefix(String arg0, String arg1) throws XMLStreamException {
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public void setDefaultPrefix(String defaultPrefix) {
        this.defaultPrefix = defaultPrefix;
    }

    public Map<String, String> getPeferredPrefixes() {
        return this.peferredPrefixes;
    }

    public void setPeferredPrefixes(Map<String, String> peferredPrefixes) {
        this.peferredPrefixes = peferredPrefixes;
    }

    public boolean isIncludeXMLDeclaration() {
        return this.includeXMLDeclaration;
    }

    public void setIncludeXMLDeclaration(boolean includeXMLDeclaration) {
        this.includeXMLDeclaration = includeXMLDeclaration;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    private static final class ProwideNamespaceContext
    implements NamespaceContext {
        private ProwideNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

