/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class TestUtils {
    private static final String MTXXXMESSAGE = "Use new MTxxx plus the append methods instead.";

    private TestUtils() {
        throw new AssertionError();
    }

    public static SwiftMessage createMT(int type) {
        SwiftMessage result = new SwiftMessage(true);
        SwiftBlock2Input b2 = new SwiftBlock2Input();
        b2.setMessageType(Integer.toString(type));
        b2.setInput(true);
        b2.setMessagePriority("N");
        b2.setDeliveryMonitoring("2");
        b2.setObsolescencePeriod("020");
        b2.setReceiverAddress("12345612XXXX");
        result.setBlock2(b2);
        return result;
    }

    @Deprecated
    public static SwiftMessage createMT(int i, Tag ... tags) {
        DeprecationUtils.phase3(TestUtils.class, "createMT(int, Tag...)", MTXXXMESSAGE);
        SwiftMessage result = TestUtils.createMT(i);
        if (tags != null && tags.length > 0) {
            for (Tag t : tags) {
                result.getBlock4().append(t);
            }
        }
        return result;
    }

    @Deprecated
    public static SwiftMessage createMT(int i, SwiftTagListBlock ... blocks) {
        DeprecationUtils.phase3(TestUtils.class, "createMT(int, SwiftTagListBlock...)", MTXXXMESSAGE);
        SwiftMessage result = TestUtils.createMT(i);
        if (blocks != null && blocks.length > 0) {
            for (SwiftTagListBlock b : blocks) {
                result.getBlock4().getTags().addAll(b.getTags());
            }
        }
        return result;
    }

    public static SwiftMessage addSeq(SwiftMessage msg, String sequenceIdentifier, Tag ... tags) {
        msg.getBlock4().append(new Tag("16R", sequenceIdentifier));
        if (tags != null && tags.length > 0) {
            for (Tag t : tags) {
                msg.getBlock4().append(t);
            }
        }
        msg.getBlock4().append(new Tag("16S", sequenceIdentifier));
        return msg;
    }

    public static SwiftMessage enclose(SwiftMessage msg, String sequenceIdentifier, Tag ... tags) {
        List<Tag> block4 = msg.getBlock4().getTags();
        block4.add(0, new Tag("16R", sequenceIdentifier));
        if (tags != null && tags.length > 0) {
            for (int i = tags.length - 1; i >= 0; --i) {
                block4.add(1, tags[i]);
            }
        }
        block4.add(new Tag("16S", sequenceIdentifier));
        return msg;
    }

    @Deprecated
    public static SwiftMessage createMTwithEmptyTags(int i, String ... tags) {
        DeprecationUtils.phase3(TestUtils.class, "createMTwithEmptyTags(int, String...)", MTXXXMESSAGE);
        SwiftMessage r = TestUtils.createMT(i, (Tag[])null);
        if (tags != null && tags.length > 0) {
            for (String n : tags) {
                r.getBlock4().append(new Tag(n, "ignored"));
            }
        }
        return r;
    }

    @Deprecated
    public static Tag[] newSeq(String startEnd16rs, Tag ... tags) {
        DeprecationUtils.phase3(TestUtils.class, "newSeq(String, Tag...)", MTXXXMESSAGE);
        ArrayList<Tag> result = new ArrayList<Tag>();
        result.add(new Tag("16R", startEnd16rs));
        if (tags != null && tags.length > 0) {
            for (Tag t : tags) {
                result.add(t);
            }
        }
        result.add(new Tag("16S", startEnd16rs));
        return result.toArray(new Tag[result.size()]);
    }

    @Deprecated
    public static Tag[] newSeq(String startEnd16rs, String ... tagnames) {
        DeprecationUtils.phase3(TestUtils.class, "newSeq(String, String...)", MTXXXMESSAGE);
        ArrayList<Tag> result = new ArrayList<Tag>();
        result.add(new Tag("16R", startEnd16rs));
        if (tagnames != null && tagnames.length > 0) {
            for (String name : tagnames) {
                result.add(new Tag(name, ""));
            }
        }
        result.add(new Tag("16S", startEnd16rs));
        return result.toArray(new Tag[result.size()]);
    }

    public static void append(SwiftMessage m, SwiftTagListBlock block) {
        Validate.notNull((Object)m, (String)"message must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)block, (String)"block must not be null", (Object[])new Object[0]);
        m.getBlock4().append(block);
    }

    public static String patch(String xpath) {
        StringBuilder result = new StringBuilder();
        for (String s : StringUtils.split((String)xpath, (String)"/")) {
            result.append("/*[local-name()='" + s + "']");
        }
        return result.toString();
    }
}

