/*
 * Copyright 2006-2018 Prowide
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.prowidesoftware.swift;

import com.prowidesoftware.deprecation.ProwideDeprecated;
import com.prowidesoftware.deprecation.TargetYear;

/**
 * Interface for naming sequences
 * @since 7.8.1
 *
 * @deprecated usage of this interface as enum is discouraged, create custom and specific enum as necessary
 */
@Deprecated
@ProwideDeprecated(phase3= TargetYear.SRU2020)
public interface SequenceName {
	String A = "A";
	String A1 = "A1";
	String A1a = "A1a";
	String A1b = "A1b";
	String A1c = "A1c";
	String A1d = "A1d";
	String A1e = "A1e";
	String A2 = "A2";
	String A2a = "A2a";
	String A2b = "A2b";
	String A2c = "A2c";
	String A2d = "A2d";
	String A2e = "A2e";
	String A3 = "A3";
	String A3a = "A3a";
	String A3b = "A3b";
	String A3c = "A3c";
	String A3d = "A3d";
	String A3e = "A3e";
	String A4 = "A4";
	String A4a = "A4a";
	String A4b = "A4b";
	String A4c = "A4c";
	String A4d = "A4d";
	String A4e = "A4e";
	String A5 = "A5";
	String A5a = "A5a";
	String A5b = "A5b";
	String A5c = "A5c";
	String A5d = "A5d";
	String A5e = "A5e";
	String B = "B";
	String B1 = "B1";
	String B1a = "B1a";
	String B1b = "B1b";
	String B1c = "B1c";
	String B1d = "B1d";
	String B1e = "B1e";
	String B2 = "B2";
	String B2a = "B2a";
	String B2b = "B2b";
	String B2c = "B2c";
	String B2d = "B2d";
	String B2e = "B2e";
	String B3 = "B3";
	String B3a = "B3a";
	String B3b = "B3b";
	String B3c = "B3c";
	String B3d = "B3d";
	String B3e = "B3e";
	String B4 = "B4";
	String B4a = "B4a";
	String B4b = "B4b";
	String B4c = "B4c";
	String B4d = "B4d";
	String B4e = "B4e";
	String B5 = "B5";
	String B5a = "B5a";
	String B5b = "B5b";
	String B5c = "B5c";
	String B5d = "B5d";
	String B5e = "B5e";
	String C = "C";
	String C1 = "C1";
	String C1a = "C1a";
	String C1b = "C1b";
	String C1c = "C1c";
	String C1d = "C1d";
	String C1e = "C1e";
	String C2 = "C2";
	String C2a = "C2a";
	String C2b = "C2b";
	String C2c = "C2c";
	String C2d = "C2d";
	String C2e = "C2e";
	String C3 = "C3";
	String C3a = "C3a";
	String C3b = "C3b";
	String C3c = "C3c";
	String C3d = "C3d";
	String C3e = "C3e";
	String C4 = "C4";
	String C4a = "C4a";
	String C4b = "C4b";
	String C4c = "C4c";
	String C4d = "C4d";
	String C4e = "C4e";
	String C5 = "C5";
	String C5a = "C5a";
	String C5b = "C5b";
	String C5c = "C5c";
	String C5d = "C5d";
	String C5e = "C5e";
	String D = "D";
	String D1 = "D1";
	String D1a = "D1a";
	String D1b = "D1b";
	String D1c = "D1c";
	String D1d = "D1d";
	String D1e = "D1e";
	String D2 = "D2";
	String D2a = "D2a";
	String D2b = "D2b";
	String D2c = "D2c";
	String D2d = "D2d";
	String D2e = "D2e";
	String D3 = "D3";
	String D3a = "D3a";
	String D3b = "D3b";
	String D3c = "D3c";
	String D3d = "D3d";
	String D3e = "D3e";
	String D4 = "D4";
	String D4a = "D4a";
	String D4b = "D4b";
	String D4c = "D4c";
	String D4d = "D4d";
	String D4e = "D4e";
	String D5 = "D5";
	String D5a = "D5a";
	String D5b = "D5b";
	String D5c = "D5c";
	String D5d = "D5d";
	String D5e = "D5e";
	String E = "E";
	String E1 = "E1";
	String E2 = "E2";
	String E2a = "E2a";
	String E2b = "E2b";
	String E2c = "E2c";
	String E2d = "E2d";
	String E2e = "E2e";
	String E3 = "E3";
	String E3a = "E3a";
	String E3b = "E3b";
	String E3c = "E3c";
	String E3d = "E3d";
	String E3e = "E3e";
	String E4 = "E4";
	String E4a = "E4a";
	String E4b = "E4b";
	String E4c = "E4c";
	String E4d = "E4d";
	String E4e = "E4e";
	String E5 = "E5";
	String E5a = "E5a";
	String E5b = "E5b";
	String E5c = "E5c";
	String E5d = "E5d";
	String E5e = "E5e";

	String F = "F";
	String F1 = "F1";
	String F2 = "F2";
	String F3 = "F3";
	String F3a = "F3a";
	String F3b = "F3b";
	String F3c = "F3c";
	String F3d = "F3d";
	String F3e = "F3e";
	String F4 = "F4";
	String F4a = "F4a";
	String F4b = "F4b";
	String F4c = "F4c";
	String F4d = "F4d";
	String F4e = "F4e";
	String F5 = "F5";
	String F5a = "F5a";
	String F5b = "F5b";
	String F5c = "F5c";
	String F5d = "F5d";
	String F5e = "F5e";
	String G = "G";
	String G1 = "G1";
	String G1a = "G1a";
	String G1b = "G1b";
	String G1c = "G1c";
	String G1d = "G1d";
	String G1e = "G1e";
	String G2 = "G2";
	String G3 = "G3";
	String G4 = "G4";
	String G4a = "G4a";
	String G4b = "G4b";
	String G4c = "G4c";
	String G4d = "G4d";
	String G4e = "G4e";
	String G5 = "G5";
	String G5a = "G5a";
	String G5b = "G5b";
	String G5c = "G5c";
	String G5d = "G5d";
	String G5e = "G5e";
	String H = "H";
	String H1 = "H1";
	String H1a = "H1a";
	String H1b = "H1b";
	String H1c = "H1c";
	String H1d = "H1d";
	String H1e = "H1e";
	String H2 = "H2";
	String H2a = "H2a";
	String H2b = "H2b";
	String H2c = "H2c";
	String H2d = "H2d";
	String H2e = "H2e";
	String H3 = "H3";
	String H4 = "H4";
	String H5 = "H5";
	String H5a = "H5a";
	String H5b = "H5b";
	String H5c = "H5c";
	String H5d = "H5d";
	String H5e = "H5e";
	String I = "I";
	String I1 = "I1";
	String I1a = "I1a";
	String I1b = "I1b";
	String I1c = "I1c";
	String I1d = "I1d";
	String I1e = "I1e";
	String I2 = "I2";
	String I2a = "I2a";
	String I2b = "I2b";
	String I2c = "I2c";
	String I2d = "I2d";
	String I2e = "I2e";
	String I3 = "I3";
	String I3a = "I3a";
	String I3b = "I3b";
	String I3c = "I3c";
	String I3d = "I3d";
	String I3e = "I3e";
	String I4 = "I4";
	String I5 = "I5";
	String J = "J";
	String J1 = "J1";
	String J1a = "J1a";
	String J1b = "J1b";
	String J1c = "J1c";
	String J1d = "J1d";
	String J1e = "J1e";
	String J2 = "J2";
	String J2a = "J2a";
	String J2b = "J2b";
	String J2c = "J2c";
	String J2d = "J2d";
	String J2e = "J2e";
	String J3 = "J3";
	String J3a = "J3a";
	String J3b = "J3b";
	String J3c = "J3c";
	String J3d = "J3d";
	String J3e = "J3e";
	String J4 = "J4";
	String J4a = "J4a";
	String J4b = "J4b";
	String J4c = "J4c";
	String J4d = "J4d";
	String J4e = "J4e";
	String J5 = "J5";
	String K = "K";
	String K1 = "K1";
	String K1a = "K1a";
	String K1b = "K1b";
	String K1c = "K1c";
	String K1d = "K1d";
	String K1e = "K1e";
	String K2 = "K2";
	String K2a = "K2a";
	String K2b = "K2b";
	String K2c = "K2c";
	String K2d = "K2d";
	String K2e = "K2e";
	String K3 = "K3";
	String K3a = "K3a";
	String K3b = "K3b";
	String K3c = "K3c";
	String K3d = "K3d";
	String K3e = "K3e";
	String K4 = "K4";
	String K4a = "K4a";
	String K4b = "K4b";
	String K4c = "K4c";
	String K4d = "K4d";
	String K4e = "K4e";
	String K5 = "K5";
	String K5a = "K5a";
	String K5b = "K5b";
	String K5c = "K5c";
	String K5d = "K5d";
	String K5e = "K5e";
	String L = "L";
	String L1 = "L1";
	String L2 = "L2";
	String L2a = "L2a";
	String L2b = "L2b";
	String L2c = "L2c";
	String L2d = "L2d";
	String L2e = "L2e";
	String L3 = "L3";
	String L3a = "L3a";
	String L3b = "L3b";
	String L3c = "L3c";
	String L3d = "L3d";
	String L3e = "L3e";
	String L4 = "L4";
	String L4a = "L4a";
	String L4b = "L4b";
	String L4c = "L4c";
	String L4d = "L4d";
	String L4e = "L4e";
	String L5 = "L5";
	String L5a = "L5a";
	String L5b = "L5b";
	String L5c = "L5c";
	String L5d = "L5d";
	String L5e = "L5e";

	String M1 = "M1";
	String M2 = "M2";
	String M3 = "M3";
	String M3a = "M3a";
	String M3b = "M3b";
	String M3c = "M3c";
	String M3d = "M3d";
	String M3e = "M3e";
	String M4 = "M4";
	String M4a = "M4a";
	String M4b = "M4b";
	String M4c = "M4c";
	String M4d = "M4d";
	String M4e = "M4e";
	String M5 = "M5";
	String M5a = "M5a";
	String M5b = "M5b";
	String M5c = "M5c";
	String M5d = "M5d";
	String M5e = "M5e";
	
	String N1 = "N1";
	String N1a = "N1a";
	String N1b = "N1b";
	String N1c = "N1c";
	String N1d = "N1d";
	String N1e = "N1e";
	String N2 = "N2";
	String N3 = "N3";
	String N4 = "N4";
	String N4a = "N4a";
	String N4b = "N4b";
	String N4c = "N4c";
	String N4d = "N4d";
	String N4e = "N4e";
	String N5 = "N5";
	String N5a = "N5a";
	String N5b = "N5b";
	String N5c = "N5c";
	String N5d = "N5d";
	String N5e = "N5e";
	String O = "O";
	
	String O1 = "O1";
	String O1a = "O1a";
	String O1b = "O1b";
	String O1c = "O1c";
	String O1d = "O1d";
	String O1e = "O1e";
	String O2 = "O2";
	String O2a = "O2a";
	String O2b = "O2b";
	String O2c = "O2c";
	String O2d = "O2d";
	String O2e = "O2e";
	String O3 = "O3";
	String O4 = "O4";
	String O5 = "O5";
	String O5a = "O5a";
	String O5b = "O5b";
	String O5c = "O5c";
	String O5d = "O5d";
	String O5e = "O5e";
	String P = "P";

	String P1 = "P1";
	String P1a = "P1a";
	String P1b = "P1b";
	String P1c = "P1c";
	String P1d = "P1d";
	String P1e = "P1e";
	String P2 = "P2";
	String P2a = "P2a";
	String P2b = "P2b";
	String P2c = "P2c";
	String P2d = "P2d";
	String P2e = "P2e";
	String P3 = "P3";
	String P3a = "P3a";
	String P3b = "P3b";
	String P3c = "P3c";
	String P3d = "P3d";
	String P3e = "P3e";
	String P4 = "P4";
	String P5 = "P5";

	String Q1 = "Q1";
	String Q1a = "Q1a";
	String Q1b = "Q1b";
	String Q1c = "Q1c";
	String Q1d = "Q1d";
	String Q1e = "Q1e";
	String Q2 = "Q2";
	String Q2a = "Q2a";
	String Q2b = "Q2b";
	String Q2c = "Q2c";
	String Q2d = "Q2d";
	String Q2e = "Q2e";
	String Q3 = "Q3";
	String Q3a = "Q3a";
	String Q3b = "Q3b";
	String Q3c = "Q3c";
	String Q3d = "Q3d";
	String Q3e = "Q3e";
	String Q4 = "Q4";
	String Q4a = "Q4a";
	String Q4b = "Q4b";
	String Q4c = "Q4c";
	String Q4d = "Q4d";
	String Q4e = "Q4e";
	String Q5 = "Q5";
	String R = "R";
	String R1 = "R1";
	String R1a = "R1a";
	String R1b = "R1b";
	String R1c = "R1c";
	String R1d = "R1d";
	String R1e = "R1e";
	String R2 = "R2";
	String R2a = "R2a";
	String R2b = "R2b";
	String R2c = "R2c";
	String R2d = "R2d";
	String R2e = "R2e";
	String R3 = "R3";
	String R3a = "R3a";
	String R3b = "R3b";
	String R3c = "R3c";
	String R3d = "R3d";
	String R3e = "R3e";
	String R4 = "R4";
	String R4a = "R4a";
	String R4b = "R4b";
	String R4c = "R4c";
	String R4d = "R4d";
	String R4e = "R4e";
	String R5 = "R5";
	String R5a = "R5a";
	String R5b = "R5b";
	String R5c = "R5c";
	String R5d = "R5d";
	String R5e = "R5e";
	String S = "S";
	String S1 = "S1";
	String S2 = "S2";
	String S2a = "S2a";
	String S2b = "S2b";
	String S2c = "S2c";
	String S2d = "S2d";
	String S2e = "S2e";
	String S3 = "S3";
	String S3a = "S3a";
	String S3b = "S3b";
	String S3c = "S3c";
	String S3d = "S3d";
	String S3e = "S3e";
	String S4 = "S4";
	String S4a = "S4a";
	String S4b = "S4b";
	String S4c = "S4c";
	String S4d = "S4d";
	String S4e = "S4e";
	String S5 = "S5";
	String S5a = "S5a";
	String S5b = "S5b";
	String S5c = "S5c";
	String S5d = "S5d";
	String S5e = "S5e";

	String T = "T";
	String T1 = "T1";
	String T2 = "T2";
	String T3 = "T3";
	String T3a = "T3a";
	String T3b = "T3b";
	String T3c = "T3c";
	String T3d = "T3d";
	String T3e = "T3e";
	String T4 = "T4";
	String T4a = "T4a";
	String T4b = "T4b";
	String T4c = "T4c";
	String T4d = "T4d";
	String T4e = "T4e";
	String T5 = "T5";
	String T5a = "T5a";
	String T5b = "T5b";
	String T5c = "T5c";
	String T5d = "T5d";
	String T5e = "T5e";

	String U = "U";
	String U1 = "U1";
	String U1a = "U1a";
	String U1b = "U1b";
	String U1c = "U1c";
	String U1d = "U1d";
	String U1e = "U1e";
	String U2 = "U2";
	String U3 = "U3";
	String U4 = "U4";
	String U4a = "U4a";
	String U4b = "U4b";
	String U4c = "U4c";
	String U4d = "U4d";
	String U4e = "U4e";
	String U5 = "U5";
	String U5a = "U5a";
	String U5b = "U5b";
	String U5c = "U5c";
	String U5d = "U5d";
	String U5e = "U5e";
	String V = "V";
	
	String V1 = "V1";
	String V1a = "V1a";
	String V1b = "V1b";
	String V1c = "V1c";
	String V1d = "V1d";
	String V1e = "V1e";
	String V2 = "V2";
	String V2a = "V2a";
	String V2b = "V2b";
	String V2c = "V2c";
	String V2d = "V2d";
	String V2e = "V2e";
	String V3 = "V3";
	String V4 = "V4";
	String V5 = "V5";
	String V5a = "V5a";
	String V5b = "V5b";
	String V5c = "V5c";
	String V5d = "V5d";
	String V5e = "V5e";
	String W = "W";

	String W1 = "W1";
	String W1a = "W1a";
	String W1b = "W1b";
	String W1c = "W1c";
	String W1d = "W1d";
	String W1e = "W1e";
	String W2 = "W2";
	String W2a = "W2a";
	String W2b = "W2b";
	String W2c = "W2c";
	String W2d = "W2d";
	String W2e = "W2e";
	String W3 = "W3";
	String W3a = "W3a";
	String W3b = "W3b";
	String W3c = "W3c";
	String W3d = "W3d";
	String W3e = "W3e";
	String W4 = "W4";
	String W5 = "W5";
	
	String X1 = "X1";
	String X1a = "X1a";
	String X1b = "X1b";
	String X1c = "X1c";
	String X1d = "X1d";
	String X1e = "X1e";
	String X2 = "X2";
	String X2a = "X2a";
	String X2b = "X2b";
	String X2c = "X2c";
	String X2d = "X2d";
	String X2e = "X2e";
	String X3 = "X3";
	String X3a = "X3a";
	String X3b = "X3b";
	String X3c = "X3c";
	String X3d = "X3d";
	String X3e = "X3e";
	String X4 = "X4";
	String X4a = "X4a";
	String X4b = "X4b";
	String X4c = "X4c";
	String X4d = "X4d";
	String X4e = "X4e";
	String X5 = "X5";
	String Y = "Y";
	String Y1 = "Y1";
	String Y1a = "Y1a";
	String Y1b = "Y1b";
	String Y1c = "Y1c";
	String Y1d = "Y1d";
	String Y1e = "Y1e";
	String Y2 = "Y2";
	String Y2a = "Y2a";
	String Y2b = "Y2b";
	String Y2c = "Y2c";
	String Y2d = "Y2d";
	String Y2e = "Y2e";
	String Y3 = "Y3";
	String Y3a = "Y3a";
	String Y3b = "Y3b";
	String Y3c = "Y3c";
	String Y3d = "Y3d";
	String Y3e = "Y3e";
	String Y4 = "Y4";
	String Y4a = "Y4a";
	String Y4b = "Y4b";
	String Y4c = "Y4c";
	String Y4d = "Y4d";
	String Y4e = "Y4e";
	String Y5 = "Y5";
	String Y5a = "Y5a";
	String Y5b = "Y5b";
	String Y5c = "Y5c";
	String Y5d = "Y5d";
	String Y5e = "Y5e";
	String Z = "Z";
	String Z1 = "Z1";
	String Z2 = "Z2";
	String Z2a = "Z2a";
	String Z2b = "Z2b";
	String Z2c = "Z2c";
	String Z2d = "Z2d";
	String Z2e = "Z2e";
	String Z3 = "Z3";
	String Z3a = "Z3a";
	String Z3b = "Z3b";
	String Z3c = "Z3c";
	String Z3d = "Z3d";
	String Z3e = "Z3e";
	String Z4 = "Z4";
	String Z4a = "Z4a";
	String Z4b = "Z4b";
	String Z4c = "Z4c";
	String Z4d = "Z4d";
	String Z4e = "Z4e";
	String Z5 = "Z5";
	String Z5a = "Z5a";
	String Z5b = "Z5b";
	String Z5c = "Z5c";
	String Z5d = "Z5d";
	String Z5e = "Z5e";
}
