
package com.prowidesoftware.swift.model.mx.dic;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * 
 */
@XmlType(name = "AddressType2Code")
@XmlEnum
public enum AddressType2Code {


    /**
     * Address is the complete postal address.
     * 
     */
    ADDR,

    /**
     * Address is a postal office (PO) box.
     * 
     */
    PBOX,

    /**
     * Address is the home address.
     * 
     */
    HOME,

    /**
     * Address is the business address.
     * 
     */
    BIZZ,

    /**
     * Address is the address to which mail is sent.
     * 
     */
    MLTO,

    /**
     * Address is the address to which delivery is to take place.
     * 
     */
    DLVY;

    public String value() {
        return name();
    }

    public static AddressType2Code fromValue(String v) {
        return valueOf(v);
    }

}
