/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.deprecation;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class DeprecationUtils {
    private static final transient Logger log = Logger.getLogger(DeprecationUtils.class.getName());
    public static final String PW_DEPRECATED = "PW_DEPRECATED";

    private DeprecationUtils() {
        throw new AssertionError();
    }

    public static void phase2(Class clazz, String method, String message) {
        if (!DeprecationUtils.isSet(EnvironmentVariableKey.NOLOG)) {
            log.warning(DeprecationUtils.notice(clazz, method) + message);
        }
        if (!DeprecationUtils.isSet(EnvironmentVariableKey.NODELAY)) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.log(Level.WARNING, DeprecationUtils.notice(clazz, method) + message, e);
            }
        }
    }

    private static String notice(Class clazz, String method) {
        StringBuilder note = new StringBuilder();
        note.append("The API ").append(clazz.getSimpleName());
        if (method != null) {
            note.append("#").append(method);
        }
        note.append(" is deprecated. ");
        return note.toString();
    }

    public static void phase3(Class clazz, String method, String message) {
        if (!DeprecationUtils.isSet(EnvironmentVariableKey.NOEXCEPTION)) {
            throw new UnsupportedOperationException(DeprecationUtils.notice(clazz, method) + message);
        }
        DeprecationUtils.phase2(clazz, method, message);
    }

    private static final boolean isSet(EnvironmentVariableKey key) {
        return StringUtils.containsIgnoreCase((CharSequence)System.getenv(PW_DEPRECATED), (CharSequence)key.name());
    }

    public static void setEnv(EnvironmentVariableKey ... keys) {
        if (keys != null && keys.length > 0) {
            StringBuilder value = new StringBuilder();
            for (EnvironmentVariableKey key : keys) {
                if (value.length() > 0) {
                    value.append(",");
                }
                value.append(key.name().toLowerCase());
            }
            DeprecationUtils.setEnv(PW_DEPRECATED, value.toString());
        }
    }

    public static void clearEnv() {
        DeprecationUtils.setEnv(PW_DEPRECATED, "");
    }

    private static void setEnv(String key, String value) {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.put(key, value);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.put(key, value);
        }
        catch (NoSuchFieldException e) {
            try {
                Class<?>[] classes = Collections.class.getDeclaredClasses();
                Map<String, String> env = System.getenv();
                for (Class<?> cl : classes) {
                    if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                    Field field = cl.getDeclaredField("m");
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                    map.put(key, value);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static enum EnvironmentVariableKey {
        NOLOG,
        NODELAY,
        NOEXCEPTION;

    }
}

