/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.parser;

import com.prowidesoftware.swift.io.parser.MxBusinessHeaderParser;
import com.prowidesoftware.swift.io.parser.MxNodeContentHandler;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.MxNode;
import com.prowidesoftware.swift.model.mx.BusinessHeader;
import com.prowidesoftware.swift.model.mx.dic.ApplicationHeader;
import com.prowidesoftware.swift.model.mx.dic.BusinessApplicationHeaderV01;
import com.prowidesoftware.swift.utils.Lib;
import com.prowidesoftware.swift.utils.SafeXmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class MxParser {
    private static final Logger log = Logger.getLogger(MxParser.class.getName());
    public static final String HEADER_LOCALNAME = "AppHdr";
    public static final String DOCUMENT_LOCALNAME = "Document";
    private String buffer = null;
    private MxStructureInfo info = null;

    public MxParser(File file) throws IOException {
        Validate.notNull((Object)file);
        this.buffer = Lib.readFile(file);
    }

    public MxParser(InputStream stream) throws IOException {
        this.buffer = Lib.readStream(stream);
    }

    public MxParser(String message) {
        this.buffer = message;
    }

    public MxNode parse() {
        Validate.notNull((Object)this.buffer, (String)"the source must be initialized", (Object[])new Object[0]);
        try {
            XMLReader xmlReader = SafeXmlUtils.reader(true, null);
            MxNodeContentHandler contentHandler = new MxNodeContentHandler();
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(new InputSource(new StringReader(this.buffer)));
            return contentHandler.getRootNode();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing XML", e);
            return null;
        }
    }

    public BusinessHeader parseBusinessHeader() {
        MxNode appHdr;
        BusinessHeader bh = new BusinessHeader();
        MxNode tree = this.parse();
        if (tree != null && (appHdr = tree.findFirstByName(HEADER_LOCALNAME)) != null) {
            String ns = appHdr.getAttribute("xmlns");
            if (ns != null && ns.equals("urn:swift:xsd:$ahV10") || appHdr.findFirstByName("From") != null) {
                bh.setApplicationHeader(MxParser.parseApplicationHeader(tree));
            } else {
                bh.setBusinessApplicationHeader(MxParser.parseBusinessApplicationHeaderV01(tree));
            }
            return bh;
        }
        return null;
    }

    public static BusinessHeader parseBusinessHeader(Element e) {
        DOMImplementationLS lsImpl = (DOMImplementationLS)e.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer serializer = lsImpl.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        String xml = serializer.writeToString(e);
        MxParser parser = new MxParser(xml);
        return parser.parseBusinessHeader();
    }

    public ApplicationHeader parseApplicationHeader() {
        return MxParser.parseApplicationHeader(this.parse());
    }

    public static ApplicationHeader parseApplicationHeader(MxNode tree) {
        return MxBusinessHeaderParser.parseApplicationHeader(tree);
    }

    public BusinessApplicationHeaderV01 parseBusinessApplicationHeaderV01() {
        return MxParser.parseBusinessApplicationHeaderV01(this.parse());
    }

    public static BusinessApplicationHeaderV01 parseBusinessApplicationHeaderV01(MxNode tree) {
        return MxBusinessHeaderParser.parseBusinessApplicationHeaderV01(tree);
    }

    public MxId detectMessage() {
        if (StringUtils.isBlank((CharSequence)this.buffer)) {
            log.log(Level.SEVERE, "cannot detect message from null or empty content");
            return null;
        }
        XMLInputFactory xif = SafeXmlUtils.inputFactory();
        try {
            XMLStreamReader reader = xif.createXMLStreamReader(new StringReader(this.buffer));
            while (reader.hasNext()) {
                int event = reader.next();
                if (1 != event || !reader.getLocalName().equals(DOCUMENT_LOCALNAME) || reader.getNamespaceCount() <= 0) continue;
                for (int nsIndex = 0; nsIndex < reader.getNamespaceCount(); ++nsIndex) {
                    String elementPrefix;
                    String nsPrefix = StringUtils.trimToNull((String)reader.getNamespacePrefix(nsIndex));
                    if (!StringUtils.equals((CharSequence)nsPrefix, (CharSequence)(elementPrefix = StringUtils.trimToNull((String)reader.getPrefix())))) continue;
                    String nsId = reader.getNamespaceURI(nsIndex);
                    return new MxId(nsId);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error while detecting message", e);
        }
        return null;
    }

    @Deprecated
    public MxStructureInfo analizeMessage() {
        return this.analyzeMessage();
    }

    public MxStructureInfo analyzeMessage() {
        if (this.info != null) {
            return this.info;
        }
        this.info = new MxStructureInfo();
        if (StringUtils.isBlank((CharSequence)this.buffer)) {
            log.log(Level.WARNING, "cannot analyze message from null or empty content");
            return this.info;
        }
        XMLInputFactory xif = SafeXmlUtils.inputFactory();
        try {
            XMLStreamReader reader = xif.createXMLStreamReader(new StringReader(this.buffer));
            boolean first = true;
            while (reader.hasNext()) {
                int event = reader.next();
                if (1 != event) continue;
                if (!this.info.containsDocument && reader.getLocalName().equals(DOCUMENT_LOCALNAME)) {
                    this.info.containsDocument = true;
                    this.info.documentNamespace = this.readNamespace(reader);
                    this.info.documentPrefix = StringUtils.trimToNull((String)reader.getPrefix());
                } else if (!this.info.containsHeader && reader.getLocalName().equals(HEADER_LOCALNAME)) {
                    this.info.containsHeader = true;
                    this.info.headerNamespace = this.readNamespace(reader);
                    this.info.headerPrefix = StringUtils.trimToNull((String)reader.getPrefix());
                } else if (first) {
                    this.info.containsWrapper = true;
                }
                first = false;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error while analyzing message: " + e.getMessage());
            this.info.exception = e;
        }
        return this.info;
    }

    private String readNamespace(XMLStreamReader reader) {
        if (reader.getNamespaceCount() > 0) {
            for (int nsIndex = 0; nsIndex < reader.getNamespaceCount(); ++nsIndex) {
                String elementPrefix;
                String nsPrefix = StringUtils.trimToNull((String)reader.getNamespacePrefix(nsIndex));
                if (!StringUtils.equals((CharSequence)nsPrefix, (CharSequence)(elementPrefix = StringUtils.trimToNull((String)reader.getPrefix())))) continue;
                return reader.getNamespaceURI(nsIndex);
            }
        }
        return null;
    }

    public static String getBICFromDN(String dn) {
        for (String s : StringUtils.split((String)dn, (String)",")) {
            if (!StringUtils.startsWith((CharSequence)s, (CharSequence)"o=") || StringUtils.equals((CharSequence)s, (CharSequence)"o=swift")) continue;
            return StringUtils.upperCase((String)StringUtils.substringAfter((String)s, (String)"o="));
        }
        return null;
    }

    public String stripDocument() {
        this.analyzeMessage();
        if (this.info.containsDocument) {
            String tag = this.info.getDocumentPrefix() != null ? this.info.getDocumentPrefix() + ":" + DOCUMENT_LOCALNAME : DOCUMENT_LOCALNAME;
            int beginIndex = this.buffer.indexOf("<" + tag);
            int endIndex = this.buffer.lastIndexOf("</" + tag);
            if (beginIndex >= 0 && endIndex >= 0) {
                return this.buffer.substring(beginIndex, endIndex) + "</" + tag + ">";
            }
        }
        return null;
    }

    public String stripHeader() {
        this.analyzeMessage();
        if (this.info.containsHeader()) {
            String tag = this.info.getHeaderPrefix() != null ? this.info.getHeaderPrefix() + ":" + HEADER_LOCALNAME : HEADER_LOCALNAME;
            int beginIndex = this.buffer.indexOf("<" + tag);
            int endIndex = this.buffer.indexOf("</" + tag);
            if (beginIndex >= 0 && endIndex >= 0) {
                return this.buffer.substring(beginIndex, endIndex) + "</" + tag + ">";
            }
        }
        return null;
    }

    public class MxStructureInfo {
        private boolean containsWrapper = false;
        private boolean containsHeader = false;
        private boolean containsDocument = false;
        private String documentNamespace = null;
        private String documentPrefix = null;
        private String headerNamespace = null;
        private String headerPrefix = null;
        private Exception exception = null;

        public boolean containsWrapper() {
            return this.containsWrapper;
        }

        public boolean containsHeader() {
            return this.containsHeader;
        }

        public boolean containsDocument() {
            return this.containsDocument;
        }

        public String getDocumentNamespace() {
            return this.documentNamespace;
        }

        public String getDocumentPrefix() {
            return this.documentPrefix;
        }

        public String getHeaderNamespace() {
            return this.headerNamespace;
        }

        public String getHeaderPrefix() {
            return this.headerPrefix;
        }

        public Exception getException() {
            return this.exception;
        }

        public Optional<Boolean> containsLegacyHeader() {
            if (this.containsHeader) {
                return Optional.of(StringUtils.contains((CharSequence)this.headerNamespace, (CharSequence)"ahV10"));
            }
            return Optional.empty();
        }

        public String toString() {
            return "MxStructureInfo [containsWrapper=" + this.containsWrapper + ", containsHeader=" + this.containsHeader + ", containsDocument=" + this.containsDocument + ", documentNamespace=" + this.documentNamespace + ", documentPrefix=" + this.documentPrefix + ", headerNamespace=" + this.headerNamespace + ", headerPrefix=" + this.headerPrefix + "]";
        }
    }
}

