/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.swift.io.ConversionService;
import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.FileFormat;
import com.prowidesoftware.swift.model.Money;
import com.prowidesoftware.swift.model.MtId;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.model.mt.MTVariant;
import com.prowidesoftware.swift.model.mt.ServiceIdType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Entity(name="mt")
@DiscriminatorValue(value="mt")
public class MtSwiftMessage
extends AbstractSwiftMessage {
    private static final transient Logger log = Logger.getLogger(MtSwiftMessage.class.getName());
    private static final long serialVersionUID = -5972656648349958815L;
    @Column(length=35)
    private String pde;
    @Column(length=35)
    private String pdm;
    @Column(length=28, name="mir")
    private String mir;
    @Column(length=16, name="mur")
    private String mur;
    @Column(length=31, name="uuid")
    private String uuid;

    public MtSwiftMessage() {
    }

    public MtSwiftMessage(String fin) {
        super(fin, FileFormat.FIN);
    }

    public static MtSwiftMessage parse(String fin) {
        return new MtSwiftMessage(fin);
    }

    public MtSwiftMessage(InputStream stream) throws IOException {
        super(stream, FileFormat.FIN);
    }

    public static MtSwiftMessage parse(InputStream stream) throws IOException {
        return new MtSwiftMessage(stream);
    }

    public MtSwiftMessage(File file) throws IOException {
        super(file, FileFormat.FIN);
    }

    public static MtSwiftMessage parse(File file) throws IOException {
        return new MtSwiftMessage(file);
    }

    @Override
    protected void updateFromMessage() throws IllegalArgumentException {
        if (this.getFileFormat() != FileFormat.FIN) {
            throw new IllegalArgumentException("expected source format " + (Object)((Object)FileFormat.FIN) + " and found " + (Object)((Object)this.getFileFormat()));
        }
        Validate.notNull((Object)this.getMessage(), (String)"the raw message attribute cannot be null", (Object[])new Object[0]);
        SwiftMessage model = null;
        try {
            model = SwiftMessage.parse(this.getMessage());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "the raw message parameter could not be parsed into a SwiftMessage", e);
        }
        if (model == null) {
            throw new IllegalArgumentException("the raw message parameter could not be parsed into a SwiftMessage");
        }
        this.updateAttributes(model);
    }

    private void updateAttributes(SwiftMessage model) {
        this.setFileFormat(FileFormat.FIN);
        if (model.isServiceMessage21()) {
            SwiftMessage original;
            if (model.isAck()) {
                this.identifier = "ACK";
            } else if (model.isNack()) {
                this.identifier = "NAK";
            }
            if (model.getUnparsedTextsSize() > 0 && (original = model.getUnparsedTexts().getTextAsMessage(0)) != null) {
                this.receiver = this.bic11(original.getReceiver());
                this.setDirection(original.getDirection());
                this.setReference(SwiftMessageUtils.reference(original));
            }
        } else if (model.getBlock1() != null && model.getBlock1().getServiceIdType() == ServiceIdType._01) {
            this.setIdentifier(model.getMtId().id());
            this.setReceiver(this.bic11(model.getReceiver()));
            this.setDirection(model.getDirection());
            this.setReference(SwiftMessageUtils.reference(model));
            Money money = SwiftMessageUtils.money(model);
            if (money != null) {
                this.setCurrency(money.getCurrency());
                this.setAmount(money.getAmount());
            }
            this.setValueDate(SwiftMessageUtils.valueDate(model));
            this.setTradeDate(SwiftMessageUtils.tradeDate(model));
        }
        this.setSender(this.bic11(model.getSender()));
        this.setChecksum(SwiftMessageUtils.calculateChecksum(model));
        this.setChecksumBody(SwiftMessageUtils.calculateChecksum(model.getBlock4()));
        this.setPde(model.getPDE());
        this.setPdm(model.getPDM());
        this.setMir(model.getMIR());
        this.setMur(model.getMUR());
        this.setUuid(model.getUUID());
        this.setLastModified(Calendar.getInstance());
    }

    public MtSwiftMessage(AbstractMT mt) {
        Validate.notNull((Object)mt, (String)"the mt message cannot be null", (Object[])new Object[0]);
        this.updateFromModel(mt.getSwiftMessage());
    }

    public MtSwiftMessage(SwiftMessage model) {
        this.updateFromModel(model);
    }

    public void updateFromFIN(String fin) {
        Validate.notNull((Object)fin, (String)"the raw message parameter cannot be null", (Object[])new Object[0]);
        this.setMessage(fin);
        this.setFileFormat(FileFormat.FIN);
        this.updateFromMessage();
    }

    public void updateFromFIN() {
        this.updateFromMessage();
    }

    public void updateFromModel(SwiftMessage model) {
        Validate.notNull((Object)model, (String)"the model message cannot be null", (Object[])new Object[0]);
        String fin = new ConversionService().getFIN(model);
        Validate.notNull((Object)fin, (String)"the raw message could not be created from the SwiftMessage parameter", (Object[])new Object[0]);
        this.setMessage(fin);
        this.updateAttributes(model);
    }

    public void updateFromModel(AbstractMT mt) {
        Validate.notNull((Object)mt, (String)"the model message cannot be null", (Object[])new Object[0]);
        this.updateFromModel(mt.getSwiftMessage());
    }

    public SwiftMessage modelMessage() {
        if (this.getMessage() != null) {
            try {
                return SwiftMessage.parse(this.message());
            }
            catch (IOException e) {
                log.log(Level.WARNING, "error converting FIN text to model: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public Integer getMessageTypeInt() {
        String number = this.getMessageType();
        if (number != null && StringUtils.isNumeric((CharSequence)number)) {
            return Integer.parseInt(number);
        }
        return null;
    }

    @Override
    public String getMessageName() {
        String name = super.getMessageName();
        if (name != null) {
            return name;
        }
        return this.getMessageType();
    }

    public boolean isType(Integer ... type) {
        for (Integer integer : type) {
            if (!this.isType((int)integer)) continue;
            return true;
        }
        return false;
    }

    public boolean isType(int type) {
        Integer typeInt = this.getMessageTypeInt();
        if (typeInt != null) {
            return typeInt == type;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MtSwiftMessage id=").append(this.getId()).append(" message=").append(this.getMessage());
        return sb.toString();
    }

    public String getPde() {
        return this.pde;
    }

    public void setPde(String pde) {
        this.pde = pde;
    }

    public String getPdm() {
        return this.pdm;
    }

    public void setPdm(String pdm) {
        this.pde = pdm;
    }

    public String getMir() {
        return this.mir;
    }

    public void setMir(String mir) {
        this.mir = mir;
    }

    public String getMur() {
        return this.mur;
    }

    public void setMur(String mur) {
        this.mur = mur;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MtSwiftMessage that = (MtSwiftMessage)o;
        return Objects.equals(this.pde, that.pde) && Objects.equals(this.pdm, that.pdm) && Objects.equals(this.mir, that.mir) && Objects.equals(this.mur, that.mur) && Objects.equals(this.uuid, that.uuid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pde, this.pdm, this.mir, this.mur, this.uuid);
    }

    public void copyTo(MtSwiftMessage msg) {
        super.copyTo(msg);
        msg.setMir(this.getMir());
        msg.setMur(this.getMur());
        msg.setPde(this.getPde());
        msg.setPdm(this.getPdm());
        msg.setUuid(this.getUuid());
    }

    public static MtSwiftMessage fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (MtSwiftMessage)gson.fromJson(json, MtSwiftMessage.class);
    }

    public MTVariant getVariant() {
        String s = StringUtils.substringAfterLast((String)this.identifier, (String)".");
        if (EnumUtils.isValidEnum(MTVariant.class, (String)s)) {
            return MTVariant.valueOf(s);
        }
        return null;
    }

    public MtId getMtId() {
        return new MtId(this.getMessageType(), this.getVariant());
    }
}

