/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.SwiftBlock1Field;
import com.prowidesoftware.swift.model.SwiftValueBlock;
import com.prowidesoftware.swift.model.mt.ServiceIdType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;

public class SwiftBlock1
extends SwiftValueBlock
implements Serializable {
    private static final transient Logger log = Logger.getLogger(SwiftBlock1.class.getName());
    private static final long serialVersionUID = 4229511645041690763L;
    public static final transient String APPLICATION_ID_FIN = "F";
    public static final transient String APPLICATION_ID_GPA = "A";
    public static final transient String APPLICATION_ID_LOGINS = "L";
    private String applicationId = "F";
    private String serviceId = "01";
    private String logicalTerminal;
    private String sessionNumber = "0000";
    private String sequenceNumber = "000000";

    public SwiftBlock1(String applicationId, String serviceId, String logicalTerminal, String sessionNumber, String sequenceNumber) {
        this.applicationId = applicationId;
        this.serviceId = serviceId;
        this.logicalTerminal = logicalTerminal;
        this.sessionNumber = sessionNumber;
        this.sequenceNumber = sequenceNumber;
    }

    public SwiftBlock1() {
    }

    public SwiftBlock1(String value) {
        this(value, false);
    }

    public SwiftBlock1(String value, boolean lenient) {
        this.setValue(value, lenient);
    }

    public SwiftBlock1(SwiftBlock1 block) {
        this(block.getApplicationId(), block.getServiceId(), block.getLogicalTerminal(), block.getSessionNumber(), block.getSequenceNumber());
    }

    @Override
    protected void setBlockNumber(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null", (Object[])new Object[0]);
        Validate.isTrue((blockNumber == 1 ? 1 : 0) != 0, (String)"blockNumber must be 1", (Object[])new Object[0]);
    }

    @Override
    protected void setBlockName(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null", (Object[])new Object[0]);
        Validate.isTrue((blockName.compareTo("1") == 0 ? 1 : 0) != 0, (String)"blockName must be string '1'", (Object[])new Object[0]);
    }

    @Override
    public Integer getNumber() {
        return 1;
    }

    @Override
    public String getName() {
        return "1";
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setLogicalTerminal(String logicalTerminal) {
        this.logicalTerminal = logicalTerminal;
    }

    public void setLogicalTerminal(LogicalTerminalAddress logicalTerminal) {
        this.logicalTerminal = logicalTerminal.getSenderLogicalTerminalAddress();
    }

    public void setLogicalTerminal(BIC bic) {
        this.setLogicalTerminal(new LogicalTerminalAddress(bic.getBic11()));
    }

    public void setSender(String sender) {
        this.setLogicalTerminal(new LogicalTerminalAddress(sender));
    }

    public BIC getBIC() {
        return new BIC(this.logicalTerminal);
    }

    public String getLogicalTerminal() {
        return this.logicalTerminal;
    }

    public void setSessionNumber(String sessionNumber) {
        this.sessionNumber = sessionNumber;
    }

    public String getSessionNumber() {
        return this.sessionNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public boolean isEmpty() {
        return this.applicationId == null && this.serviceId == null && this.logicalTerminal == null && this.sessionNumber == null && this.sequenceNumber == null;
    }

    @Override
    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuilder v = new StringBuilder();
        if (this.applicationId != null) {
            v.append(this.applicationId);
        }
        if (this.serviceId != null) {
            v.append(this.serviceId);
        }
        if (this.logicalTerminal != null) {
            v.append(this.logicalTerminal);
        }
        if (this.sessionNumber != null) {
            v.append(this.sessionNumber);
        }
        if (this.sequenceNumber != null) {
            v.append(this.sequenceNumber);
        }
        return v.toString();
    }

    @Override
    public String getBlockValue() {
        return this.getValue();
    }

    @Override
    public void setValue(String value) {
        this.setValue(value, false);
    }

    public void setValue(String value, boolean lenient) {
        if (lenient) {
            this.clean();
        } else {
            Validate.notNull((Object)value, (String)"value must not be null", (Object[])new Object[0]);
        }
        if (value != null) {
            int offset = 0;
            int slen = value.length();
            if (value.startsWith("1")) {
                if (!lenient) {
                    Validate.isTrue((boolean)value.startsWith("1:"), (String)("expected '1:' at the beginning of value and found '" + value.substring(0, 1) + "'"), (Object[])new Object[0]);
                    Validate.isTrue((slen == 26 || slen == 27 ? 1 : 0) != 0, (String)("block value " + value + " cannot be parsed because it has an invalid size, expected 26 or 27 and found " + value.length()), (Object[])new Object[0]);
                }
                offset = 2;
            } else if (!lenient) {
                Validate.isTrue((slen == 24 || slen == 25 ? 1 : 0) != 0, (String)("block value " + value + " cannot be parsed because it has an invalid size, expected 24 or 25 and found " + value.length()), (Object[])new Object[0]);
            }
            int len = 1;
            this.setApplicationId(this.getValuePart(value, offset, len));
            offset += len;
            len = 2;
            this.setServiceId(this.getValuePart(value, offset, len));
            offset += len;
            len = 12;
            this.setLogicalTerminal(this.getValuePart(value, offset, len));
            offset += len;
            len = 4;
            this.setSessionNumber(this.getValuePart(value, offset, len));
            offset += len;
            if (lenient) {
                this.setSequenceNumber(this.getValuePart(value, offset));
            } else {
                len = 6;
                this.setSequenceNumber(this.getValuePart(value, offset, len));
            }
        }
    }

    @Override
    public void setBlockValue(String value) {
        this.setValue(value);
    }

    public void clean() {
        this.applicationId = null;
        this.serviceId = null;
        this.logicalTerminal = null;
        this.sessionNumber = null;
        this.sequenceNumber = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SwiftBlock1 that = (SwiftBlock1)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.logicalTerminal, that.logicalTerminal) && Objects.equals(this.sessionNumber, that.sessionNumber) && Objects.equals(this.sequenceNumber, that.sequenceNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.serviceId, this.logicalTerminal, this.sessionNumber, this.sequenceNumber);
    }

    public String toJson() {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)this);
    }

    public static SwiftBlock1 fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (SwiftBlock1)gson.fromJson(json, SwiftBlock1.class);
    }

    public String field(SwiftBlock1Field field) {
        switch (field) {
            case ApplicationId: {
                return this.getApplicationId();
            }
            case ServiceId: {
                return this.getServiceId();
            }
            case LogicalTerminal: {
                return this.getLogicalTerminal();
            }
            case SessionNumber: {
                return this.getSessionNumber();
            }
            case SequenceNumber: {
                return this.getSequenceNumber();
            }
        }
        return null;
    }

    public void setField(SwiftBlock1Field field, String value) {
        switch (field) {
            case ApplicationId: {
                this.setApplicationId(value);
                break;
            }
            case ServiceId: {
                this.setServiceId(value);
                break;
            }
            case LogicalTerminal: {
                this.setLogicalTerminal(value);
                break;
            }
            case SessionNumber: {
                this.setSessionNumber(value);
                break;
            }
            case SequenceNumber: {
                this.setSequenceNumber(value);
                break;
            }
            default: {
                log.warning("don't know how to set " + (Object)((Object)field) + " to block1");
            }
        }
    }

    public ServiceIdType getServiceIdType() {
        try {
            return ServiceIdType.valueOf("_" + this.serviceId);
        }
        catch (Exception e) {
            String text = "Block1 serviceId contains an invalid value [" + this.serviceId + "]. The expected values are " + Arrays.toString((Object[])ServiceIdType.values());
            log.warning(text);
            log.log(Level.FINEST, text, e);
            return null;
        }
    }
}

