/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field134
extends Field
implements Serializable,
BICContainer,
MultiLineField {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "134";
    public static final String F_134 = "134";
    public static final String PARSER_PATTERN = "S$S$S";
    public static final String COMPONENTS_PATTERN = "BSS";
    public static final Integer BIC = 1;
    public static final Integer BROADCAST_REQUESTER_NAME = 2;
    public static final Integer BROADCAST_REQUESTER_CITY = 3;

    public Field134() {
        super(3);
    }

    public Field134(String value) {
        super(value);
    }

    public Field134(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"134")) {
            throw new IllegalArgumentException("cannot create field 134 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field134 newInstance(Field134 source) {
        Field134 cp = new Field134();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("134", value);
    }

    public static Tag emptyTag() {
        return new Tag("134", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(lines.get(0));
            if (lines.size() > 1) {
                this.setComponent2(lines.get(1));
            }
            if (lines.size() > 2) {
                this.setComponent3(lines.get(2));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.appendInLines(result, 1, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 134");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<BIC>$65x$65x";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("BIC");
        result.add("Broadcast Requester Name");
        result.add("Broadcast Requester City");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "bIC");
        result.put(2, "broadcastRequesterName");
        result.put(3, "broadcastRequesterCity");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public BIC getComponent1AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public String getBIC() {
        return this.getComponent(1);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getBroadcastRequesterName() {
        return this.getComponent(2);
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent3AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(3);
    }

    public String getBroadcastRequesterCity() {
        return this.getComponent(3);
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> result = new ArrayList<BIC>();
        result.add(SwiftFormatUtils.getBIC(this.getComponent(1)));
        return result;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getComponent(1));
        return result;
    }

    public Field134 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field134 setComponent1(BIC component1) {
        this.setComponent(1, SwiftFormatUtils.getBIC(component1));
        return this;
    }

    public Field134 setBIC(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field134 setBIC(BIC component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field134 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field134 setBroadcastRequesterName(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field134 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field134 setBroadcastRequesterCity(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    @Override
    public String getName() {
        return "134";
    }

    public static Field134 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("134");
        if (t == null) {
            return null;
        }
        return new Field134(t);
    }

    public static Field134 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field134.get(msg.getBlock4());
    }

    public static List<Field134> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field134.getAll(msg.getBlock4());
    }

    public static List<Field134> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("134");
        if (arr != null && arr.length > 0) {
            ArrayList<Field134> result = new ArrayList<Field134>(arr.length);
            for (Tag f : arr) {
                result.add(new Field134(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field134 cp = Field134.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field134 cp = Field134.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field134 cp = Field134.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field134 fromJson(String json) {
        Field134 field = new Field134();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("bIC") != null) {
            field.setComponent1(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("broadcastRequesterName") != null) {
            field.setComponent2(jsonObject.get("broadcastRequesterName").getAsString());
        }
        if (jsonObject.get("broadcastRequesterCity") != null) {
            field.setComponent3(jsonObject.get("broadcastRequesterCity").getAsString());
        }
        return field;
    }
}

