/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field13C
extends Field
implements Serializable {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "13C";
    public static final String F_13C = "13C";
    public static final String PARSER_PATTERN = "/S/<HHMM><SIGN><OFFSET>";
    public static final String COMPONENTS_PATTERN = "SHGO";
    public static final Integer CODE = 1;
    public static final Integer TIME = 2;
    public static final Integer SIGN = 3;
    public static final Integer OFFSET = 4;

    public Field13C() {
        super(4);
    }

    public Field13C(String value) {
        super(value);
    }

    public Field13C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"13C")) {
            throw new IllegalArgumentException("cannot create field 13C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field13C newInstance(Field13C source) {
        Field13C cp = new Field13C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("13C", value);
    }

    public static Tag emptyTag() {
        return new Tag("13C", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/", "/"));
        String toparse = SwiftParseUtils.getTokenSecondLast(SwiftParseUtils.removePrefix(value, "/"), "/");
        if (toparse != null) {
            if (toparse.length() >= 4) {
                this.setComponent2(StringUtils.substring((String)toparse, (int)0, (int)4));
            }
            if (toparse.length() >= 5) {
                this.setComponent3(StringUtils.substring((String)toparse, (int)4, (int)5));
            }
            if (toparse.length() > 5) {
                this.setComponent4(StringUtils.substring((String)toparse, (int)5));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append("/");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 13C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "/8c/<HHMM><SIGN><OFFSET>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Code");
        result.add("Time");
        result.add("Sign");
        result.add("Offset");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "code");
        result.put(2, "time");
        result.put(3, "sign");
        result.put(4, "offset");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getCode() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public String getTime() {
        return this.getComponent(2);
    }

    public Calendar getTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getSign() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getOffset(this.getComponent(4));
    }

    public String getOffset() {
        return this.getComponent(4);
    }

    public Calendar getOffsetAsCalendar() {
        return SwiftFormatUtils.getOffset(this.getComponent(4));
    }

    public Field13C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field13C setCode(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field13C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field13C setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime3(component2));
        return this;
    }

    public Field13C setTime(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field13C setTime(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field13C setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field13C setSign(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field13C setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field13C setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getOffset(component4));
        return this;
    }

    public Field13C setOffset(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field13C setOffset(Calendar component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public String getName() {
        return "13C";
    }

    public static Field13C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("13C");
        if (t == null) {
            return null;
        }
        return new Field13C(t);
    }

    public static Field13C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field13C.get(msg.getBlock4());
    }

    public static List<Field13C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field13C.getAll(msg.getBlock4());
    }

    public static List<Field13C> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("13C");
        if (arr != null && arr.length > 0) {
            ArrayList<Field13C> result = new ArrayList<Field13C>(arr.length);
            for (Tag f : arr) {
                result.add(new Field13C(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field13C fromJson(String json) {
        Field13C field = new Field13C();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("code") != null) {
            field.setComponent1(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent2(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent3(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("offset") != null) {
            field.setComponent4(jsonObject.get("offset").getAsString());
        }
        return field;
    }
}

