/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field28
extends Field
implements Serializable {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "28";
    public static final String F_28 = "28";
    public static final String PARSER_PATTERN = "S[/S]";
    public static final String COMPONENTS_PATTERN = "NN";
    public static final Integer STATEMENT_NUMBER = 1;
    public static final Integer SEQUENCE_NUMBER = 2;

    public Field28() {
        super(2);
    }

    public Field28(String value) {
        super(value);
    }

    public Field28(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"28")) {
            throw new IllegalArgumentException("cannot create field 28 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field28 newInstance(Field28 source) {
        Field28 cp = new Field28();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("28", value);
    }

    public static Tag emptyTag() {
        return new Tag("28", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 28");
        }
        if (component == 1) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "5n[/2n]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Statement Number");
        result.add("Sequence Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "statementNumber");
        result.put(2, "sequenceNumber");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getStatementNumber() {
        return this.getComponent(1);
    }

    public Number getStatementNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getSequenceNumber() {
        return this.getComponent(2);
    }

    public Number getSequenceNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field28 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field28 setComponent1(Number component1) {
        if (component1 != null) {
            this.setComponent(1, Integer.toString(component1.intValue()));
        }
        return this;
    }

    public Field28 setStatementNumber(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field28 setStatementNumber(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field28 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field28 setComponent2(Number component2) {
        if (component2 != null) {
            this.setComponent(2, Integer.toString(component2.intValue()));
        }
        return this;
    }

    public Field28 setSequenceNumber(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field28 setSequenceNumber(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public String getName() {
        return "28";
    }

    public static Field28 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("28");
        if (t == null) {
            return null;
        }
        return new Field28(t);
    }

    public static Field28 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field28.get(msg.getBlock4());
    }

    public static List<Field28> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field28.getAll(msg.getBlock4());
    }

    public static List<Field28> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("28");
        if (arr != null && arr.length > 0) {
            ArrayList<Field28> result = new ArrayList<Field28>(arr.length);
            for (Tag f : arr) {
                result.add(new Field28(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field28 fromJson(String json) {
        Field28 field = new Field28();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("statementNumber") != null) {
            field.setComponent1(jsonObject.get("statementNumber").getAsString());
        }
        if (jsonObject.get("sequenceNumber") != null) {
            field.setComponent2(jsonObject.get("sequenceNumber").getAsString());
        }
        return field;
    }
}

