/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field29K
extends Field
implements Serializable {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "29K";
    public static final String F_29K = "29K";
    public static final String PARSER_PATTERN = "S/S";
    public static final String COMPONENTS_PATTERN = "SH";
    public static final Integer LOCATION = 1;
    public static final Integer TIME = 2;

    public Field29K() {
        super(2);
    }

    public Field29K(String value) {
        super(value);
    }

    public Field29K(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"29K")) {
            throw new IllegalArgumentException("cannot create field 29K from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field29K newInstance(Field29K source) {
        Field29K cp = new Field29K();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("29K", value);
    }

    public static Tag emptyTag() {
        return new Tag("29K", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 29K");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "4!c/<HHMM>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Location");
        result.add("Time");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "location");
        result.put(2, "time");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getLocation() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public String getTime() {
        return this.getComponent(2);
    }

    public Calendar getTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public Field29K setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field29K setLocation(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field29K setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field29K setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime3(component2));
        return this;
    }

    public Field29K setTime(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field29K setTime(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public String getName() {
        return "29K";
    }

    public static Field29K get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("29K");
        if (t == null) {
            return null;
        }
        return new Field29K(t);
    }

    public static Field29K get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field29K.get(msg.getBlock4());
    }

    public static List<Field29K> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field29K.getAll(msg.getBlock4());
    }

    public static List<Field29K> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("29K");
        if (arr != null && arr.length > 0) {
            ArrayList<Field29K> result = new ArrayList<Field29K>(arr.length);
            for (Tag f : arr) {
                result.add(new Field29K(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field29K fromJson(String json) {
        Field29K field = new Field29K();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("location") != null) {
            field.setComponent1(jsonObject.get("location").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent2(jsonObject.get("time").getAsString());
        }
        return field;
    }
}

