/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field30G
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "30G";
    public static final String F_30G = "30G";
    public static final String PARSER_PATTERN = "S/S";
    public static final String COMPONENTS_PATTERN = "DD";
    public static final Integer START_DATE = 1;
    public static final Integer END_DATE = 2;

    public Field30G() {
        super(2);
    }

    public Field30G(String value) {
        super(value);
    }

    public Field30G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"30G")) {
            throw new IllegalArgumentException("cannot create field 30G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field30G newInstance(Field30G source) {
        Field30G cp = new Field30G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("30G", value);
    }

    public static Tag emptyTag() {
        return new Tag("30G", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 30G");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DATE4>/<DATE4>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Start Date");
        result.add("End Date");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "startDate");
        result.put(2, "endDate");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getStartDate() {
        return this.getComponent(1);
    }

    public Calendar getStartDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public String getEndDate() {
        return this.getComponent(2);
    }

    public Calendar getEndDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(1)));
        result.add(SwiftFormatUtils.getDate4(this.getComponent(2)));
        return result;
    }

    public Field30G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30G setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field30G setStartDate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30G setStartDate(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field30G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field30G setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate4(component2));
        return this;
    }

    public Field30G setEndDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field30G setEndDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public String getName() {
        return "30G";
    }

    public static Field30G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("30G");
        if (t == null) {
            return null;
        }
        return new Field30G(t);
    }

    public static Field30G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field30G.get(msg.getBlock4());
    }

    public static List<Field30G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field30G.getAll(msg.getBlock4());
    }

    public static List<Field30G> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("30G");
        if (arr != null && arr.length > 0) {
            ArrayList<Field30G> result = new ArrayList<Field30G>(arr.length);
            for (Tag f : arr) {
                result.add(new Field30G(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field30G fromJson(String json) {
        Field30G field = new Field30G();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("startDate") != null) {
            field.setComponent1(jsonObject.get("startDate").getAsString());
        }
        if (jsonObject.get("endDate") != null) {
            field.setComponent2(jsonObject.get("endDate").getAsString());
        }
        return field;
    }
}

