/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field30J
extends Field
implements Serializable {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "30J";
    public static final String F_30J = "30J";
    public static final String PARSER_PATTERN = "SN";
    public static final String COMPONENTS_PATTERN = "SN";
    public static final Integer INDICATOR = 1;
    public static final Integer NUMBER = 2;

    public Field30J() {
        super(2);
    }

    public Field30J(String value) {
        super(value);
    }

    public Field30J(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"30J")) {
            throw new IllegalArgumentException("cannot create field 30J from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field30J newInstance(Field30J source) {
        Field30J cp = new Field30J();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("30J", value);
    }

    public static Tag emptyTag() {
        return new Tag("30J", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 30J");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return "SN";
    }

    @Override
    public final String parserPattern() {
        return "SN";
    }

    @Override
    public final String validatorPattern() {
        return "1!a3!n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Indicator");
        result.add("Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "indicator");
        result.put(2, "number");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getIndicator() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getNumber() {
        return this.getComponent(2);
    }

    public Number getNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field30J setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30J setIndicator(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30J setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field30J setComponent2(Number component2) {
        if (component2 != null) {
            this.setComponent(2, Integer.toString(component2.intValue()));
        }
        return this;
    }

    public Field30J setNumber(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field30J setNumber(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public String getName() {
        return "30J";
    }

    public static Field30J get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("30J");
        if (t == null) {
            return null;
        }
        return new Field30J(t);
    }

    public static Field30J get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field30J.get(msg.getBlock4());
    }

    public static List<Field30J> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field30J.getAll(msg.getBlock4());
    }

    public static List<Field30J> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("30J");
        if (arr != null && arr.length > 0) {
            ArrayList<Field30J> result = new ArrayList<Field30J>(arr.length);
            for (Tag f : arr) {
                result.add(new Field30J(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field30J fromJson(String json) {
        Field30J field = new Field30J();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("indicator") != null) {
            field.setComponent1(jsonObject.get("indicator").getAsString());
        }
        if (jsonObject.get("number") != null) {
            field.setComponent2(jsonObject.get("number").getAsString());
        }
        return field;
    }
}

