/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field32K
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "32K";
    public static final String F_32K = "32K";
    public static final String PARSER_PATTERN = "cNS<CUR>N";
    public static final String COMPONENTS_PATTERN = "SNSCN";
    public static final Integer DM_MARK = 1;
    public static final Integer NUMBER_OF_DAYSMONTHS = 2;
    public static final Integer CODE = 3;
    public static final Integer CURRENCY = 4;
    public static final Integer AMOUNT = 5;

    public Field32K() {
        super(5);
    }

    public Field32K(String value) {
        super(value);
    }

    public Field32K(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"32K")) {
            throw new IllegalArgumentException("cannot create field 32K from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field32K newInstance(Field32K source) {
        Field32K cp = new Field32K();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("32K", value);
    }

    public static Tag emptyTag() {
        return new Tag("32K", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        String toparse = SwiftParseUtils.getNumericSuffix(value);
        this.setComponent2(SwiftParseUtils.getNumericPrefix(toparse));
        String toparse2 = SwiftParseUtils.getAlphaSuffix(toparse);
        this.setComponent5(SwiftParseUtils.getNumericSuffix(toparse2));
        String toparse3 = SwiftParseUtils.getAlphaPrefix(toparse2);
        if (toparse3 != null) {
            if (toparse3.length() >= 3) {
                this.setComponent4(StringUtils.substring((String)toparse3, (int)(toparse3.length() - 3), (int)toparse3.length()));
            }
            if (toparse3.length() >= 4) {
                this.setComponent3(StringUtils.substring((String)toparse3, (int)0, (int)(toparse3.length() - 3)));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 32K");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent5AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DM>3!n2!a<CUR><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/M Mark");
        result.add("Number of Days/Months");
        result.add("Code");
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "dMMark");
        result.put(2, "numberofDaysMonths");
        result.put(3, "code");
        result.put(4, "currency");
        result.put(5, "amount");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getDMMark() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getNumberofDaysMonths() {
        return this.getComponent(2);
    }

    public Number getNumberofDaysMonthsAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent3AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(3);
    }

    public String getCode() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Currency getComponent4AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public String getCurrency() {
        return this.getComponent(4);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(4));
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Number getComponent5AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public String getAmount() {
        return this.getComponent(5);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    public Field32K setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field32K setDMMark(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field32K setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field32K setComponent2(Number component2) {
        this.setComponent(2, SwiftFormatUtils.getNumber(component2));
        return this;
    }

    public Field32K setNumberofDaysMonths(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field32K setNumberofDaysMonths(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field32K setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field32K setCode(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field32K setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field32K setComponent4(Currency component4) {
        this.setComponent(4, SwiftFormatUtils.getCurrency(component4));
        return this;
    }

    public Field32K setCurrency(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field32K setCurrency(Currency component4) {
        this.setComponent4(component4);
        return this;
    }

    public Field32K setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field32K setComponent5(Number component5) {
        this.setComponent(5, SwiftFormatUtils.getNumber(component5));
        return this;
    }

    public Field32K setAmount(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field32K setAmount(Number component5) {
        this.setComponent5(component5);
        return this;
    }

    @Override
    public String getName() {
        return "32K";
    }

    public static Field32K get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("32K");
        if (t == null) {
            return null;
        }
        return new Field32K(t);
    }

    public static Field32K get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field32K.get(msg.getBlock4());
    }

    public static List<Field32K> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field32K.getAll(msg.getBlock4());
    }

    public static List<Field32K> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("32K");
        if (arr != null && arr.length > 0) {
            ArrayList<Field32K> result = new ArrayList<Field32K>(arr.length);
            for (Tag f : arr) {
                result.add(new Field32K(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field32K fromJson(String json) {
        Field32K field = new Field32K();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("dMMark") != null) {
            field.setComponent1(jsonObject.get("dMMark").getAsString());
        }
        if (jsonObject.get("numberofDaysMonths") != null) {
            field.setComponent2(jsonObject.get("numberofDaysMonths").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent3(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent4(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent5(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

