/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field37C
extends Field
implements Serializable,
DateContainer,
AmountContainer {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "37C";
    public static final String F_37C = "37C";
    public static final String PARSER_PATTERN = "N[//<DATE2>cS][/S]";
    public static final String COMPONENTS_PATTERN = "NESNS";
    public static final Integer RATE = 1;
    public static final Integer DATE = 2;
    public static final Integer DM_MARK = 3;
    public static final Integer NUMBER_OF_DAYSMONTHS = 4;
    public static final Integer INFORMATION = 5;

    public Field37C() {
        super(5);
    }

    public Field37C(String value) {
        super(value);
    }

    public Field37C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"37C")) {
            throw new IllegalArgumentException("cannot create field 37C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field37C newInstance(Field37C source) {
        Field37C cp = new Field37C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("37C", value);
    }

    public static Tag emptyTag() {
        return new Tag("37C", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "//"));
        String toparse = SwiftParseUtils.getTokenSecond(value, "//");
        if (toparse != null) {
            if (toparse.length() >= 6) {
                this.setComponent2(StringUtils.substring((String)toparse, (int)0, (int)6));
            }
            if (toparse.length() >= 7) {
                this.setComponent3(StringUtils.substring((String)toparse, (int)6, (int)7));
            }
            if (toparse.length() > 7) {
                String toparse2 = StringUtils.substring((String)toparse, (int)7);
                this.setComponent4(SwiftParseUtils.getTokenFirst(toparse2, "/"));
                this.setComponent5(SwiftParseUtils.getTokenSecondLast(toparse2, "/"));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null || this.getComponent3() != null || this.getComponent4() != null) {
            result.append("//");
            this.append(result, 2);
            this.append(result, 3);
            this.append(result, 4);
        }
        if (this.getComponent5() != null) {
            result.append("/").append(this.getComponent5());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        Format f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 37C");
        }
        if (component == 1) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<AMOUNT>12[//<DATE2><DM>3n][/16x]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        return component == 5;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Rate");
        result.add("Date");
        result.add("D/M Mark");
        result.add("Number of Days/Months");
        result.add("Information");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "rate");
        result.put(2, "date");
        result.put(3, "dMMark");
        result.put(4, "numberofDaysMonths");
        result.put(5, "information");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getRate() {
        return this.getComponent(1);
    }

    public Number getRateAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent3AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(3);
    }

    public String getDMMark() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getNumberofDaysMonths() {
        return this.getComponent(4);
    }

    public Number getNumberofDaysMonthsAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent5AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(5);
    }

    public String getInformation() {
        return this.getComponent(5);
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        return result;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    public Field37C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37C setComponent1(Number component1) {
        this.setComponent(1, SwiftFormatUtils.getNumber(component1));
        return this;
    }

    public Field37C setRate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37C setRate(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field37C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37C setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field37C setDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37C setDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field37C setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field37C setDMMark(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field37C setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field37C setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public Field37C setNumberofDaysMonths(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field37C setNumberofDaysMonths(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    public Field37C setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field37C setInformation(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    @Override
    public String getName() {
        return "37C";
    }

    public static Field37C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("37C");
        if (t == null) {
            return null;
        }
        return new Field37C(t);
    }

    public static Field37C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field37C.get(msg.getBlock4());
    }

    public static List<Field37C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field37C.getAll(msg.getBlock4());
    }

    public static List<Field37C> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("37C");
        if (arr != null && arr.length > 0) {
            ArrayList<Field37C> result = new ArrayList<Field37C>(arr.length);
            for (Tag f : arr) {
                result.add(new Field37C(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field37C fromJson(String json) {
        Field37C field = new Field37C();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("rate") != null) {
            field.setComponent1(jsonObject.get("rate").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent2(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("dMMark") != null) {
            field.setComponent3(jsonObject.get("dMMark").getAsString());
        }
        if (jsonObject.get("numberofDaysMonths") != null) {
            field.setComponent4(jsonObject.get("numberofDaysMonths").getAsString());
        }
        if (jsonObject.get("information") != null) {
            field.setComponent5(jsonObject.get("information").getAsString());
        }
        return field;
    }
}

