/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field37R
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "37R";
    public static final String F_37R = "37R";
    public static final String PARSER_PATTERN = "[S]N";
    public static final String COMPONENTS_PATTERN = "SN";
    public static final Integer SIGN = 1;
    public static final Integer RATE = 2;

    public Field37R() {
        super(2);
    }

    public Field37R(String value) {
        super(value);
    }

    public Field37R(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"37R")) {
            throw new IllegalArgumentException("cannot create field 37R from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field37R newInstance(Field37R source) {
        Field37R cp = new Field37R();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("37R", value);
    }

    public static Tag emptyTag() {
        return new Tag("37R", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 37R");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[<N>]<AMOUNT>12";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Sign");
        result.add("Rate");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "sign");
        result.put(2, "rate");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getSign() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getRate() {
        return this.getComponent(2);
    }

    public Number getRateAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    public Field37R setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37R setSign(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37R setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37R setComponent2(Number component2) {
        this.setComponent(2, SwiftFormatUtils.getNumber(component2));
        return this;
    }

    public Field37R setRate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37R setRate(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public String getName() {
        return "37R";
    }

    public static Field37R get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("37R");
        if (t == null) {
            return null;
        }
        return new Field37R(t);
    }

    public static Field37R get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field37R.get(msg.getBlock4());
    }

    public static List<Field37R> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field37R.getAll(msg.getBlock4());
    }

    public static List<Field37R> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("37R");
        if (arr != null && arr.length > 0) {
            ArrayList<Field37R> result = new ArrayList<Field37R>(arr.length);
            for (Tag f : arr) {
                result.add(new Field37R(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field37R fromJson(String json) {
        Field37R field = new Field37R();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("sign") != null) {
            field.setComponent1(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("rate") != null) {
            field.setComponent2(jsonObject.get("rate").getAsString());
        }
        return field;
    }
}

