/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field50F
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "50F";
    public static final String F_50F = "50F";
    public static final String PARSER_PATTERN = "S$S/S[$S/S]0-3";
    public static final String COMPONENTS_PATTERN = "SNSNSNSNS";
    public static final Integer PARTY_IDENTIFIER = 1;
    public static final Integer NUMBER_1 = 2;
    public static final Integer NAME_AND_ADDRESS_1 = 3;
    public static final Integer NUMBER_2 = 4;
    public static final Integer NAME_AND_ADDRESS_2 = 5;
    public static final Integer NUMBER_3 = 6;
    public static final Integer NAME_AND_ADDRESS_3 = 7;
    public static final Integer NUMBER_4 = 8;
    public static final Integer NAME_AND_ADDRESS_4 = 9;

    public Field50F() {
        super(9);
    }

    public Field50F(String value) {
        super(value);
    }

    public Field50F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"50F")) {
            throw new IllegalArgumentException("cannot create field 50F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field50F newInstance(Field50F source) {
        Field50F cp = new Field50F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("50F", value);
    }

    public static Tag emptyTag() {
        return new Tag("50F", "");
    }

    @Override
    public void parse(String value) {
        this.init(9);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(lines.get(0));
            if (lines.size() > 1) {
                this.setComponent2(SwiftParseUtils.getTokenFirst(lines.get(1), "/"));
                this.setComponent3(SwiftParseUtils.getTokenSecondLast(lines.get(1), "/"));
            }
            if (lines.size() > 2) {
                this.setComponent4(SwiftParseUtils.getTokenFirst(lines.get(2), "/"));
                this.setComponent5(SwiftParseUtils.getTokenSecondLast(lines.get(2), "/"));
            }
            if (lines.size() > 3) {
                this.setComponent6(SwiftParseUtils.getTokenFirst(lines.get(3), "/"));
                this.setComponent7(SwiftParseUtils.getTokenSecondLast(lines.get(3), "/"));
            }
            if (lines.size() > 4) {
                this.setComponent8(SwiftParseUtils.getTokenFirst(lines.get(4), "/"));
                this.setComponent9(SwiftParseUtils.getTokenSecondLast(lines.get(4), "/"));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null || this.getComponent3() != null) {
            result.append("\r\n");
            this.append(result, 2);
            result.append("/");
            this.append(result, 3);
        }
        if (this.getComponent4() != null || this.getComponent5() != null) {
            result.append("\r\n");
            this.append(result, 4);
            result.append("/");
            this.append(result, 5);
        }
        if (this.getComponent6() != null || this.getComponent7() != null) {
            result.append("\r\n");
            this.append(result, 6);
            result.append("/");
            this.append(result, 7);
        }
        if (this.getComponent8() != null || this.getComponent9() != null) {
            result.append("\r\n");
            this.append(result, 8);
            result.append("/");
            this.append(result, 9);
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 9) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 50F");
        }
        if (component == 1) {
            if (StringUtils.startsWith((CharSequence)this.getComponent(1), (CharSequence)"/")) {
                return this.getComponent(1).substring(1);
            }
            return this.getComponent(1);
        }
        if (component == 2) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent6AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 7) {
            return this.getComponent(7);
        }
        if (component == 8) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent8AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 9) {
            return this.getComponent(9);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "CUSTOM";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        if (component == 6) {
            return true;
        }
        if (component == 7) {
            return true;
        }
        if (component == 8) {
            return true;
        }
        return component == 9;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 9;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Party Identifier");
        result.add("Number 1");
        result.add("Name And Address 1");
        result.add("Number 2");
        result.add("Name And Address 2");
        result.add("Number 3");
        result.add("Name And Address 3");
        result.add("Number 4");
        result.add("Name And Address 4");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "partyIdentifier");
        result.put(2, "number1");
        result.put(3, "nameAndAddress1");
        result.put(4, "number2");
        result.put(5, "nameAndAddress2");
        result.put(6, "number3");
        result.put(7, "nameAndAddress3");
        result.put(8, "number4");
        result.put(9, "nameAndAddress4");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getPartyIdentifier() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getNumber1() {
        return this.getComponent(2);
    }

    public Number getNumber1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent3AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(3);
    }

    public String getNameAndAddress1() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getNumber2() {
        return this.getComponent(4);
    }

    public Number getNumber2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent5AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(5);
    }

    public String getNameAndAddress2() {
        return this.getComponent(5);
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Number getComponent6AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public String getNumber3() {
        return this.getComponent(6);
    }

    public Number getNumber3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public String getComponent7() {
        return this.getComponent(7);
    }

    @Deprecated
    public String getComponent7AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent7AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(7);
    }

    public String getNameAndAddress3() {
        return this.getComponent(7);
    }

    public String getComponent8() {
        return this.getComponent(8);
    }

    public Number getComponent8AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(8));
    }

    public String getNumber4() {
        return this.getComponent(8);
    }

    public Number getNumber4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(8));
    }

    public String getComponent9() {
        return this.getComponent(9);
    }

    @Deprecated
    public String getComponent9AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent9AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(9);
    }

    public String getNameAndAddress4() {
        return this.getComponent(9);
    }

    public Field50F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field50F setPartyIdentifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field50F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field50F setComponent2(Number component2) {
        if (component2 != null) {
            this.setComponent(2, Integer.toString(component2.intValue()));
        }
        return this;
    }

    public Field50F setNumber1(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field50F setNumber1(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field50F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field50F setNameAndAddress1(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field50F setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field50F setComponent4(Number component4) {
        if (component4 != null) {
            this.setComponent(4, Integer.toString(component4.intValue()));
        }
        return this;
    }

    public Field50F setNumber2(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field50F setNumber2(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    public Field50F setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field50F setNameAndAddress2(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field50F setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field50F setComponent6(Number component6) {
        if (component6 != null) {
            this.setComponent(6, Integer.toString(component6.intValue()));
        }
        return this;
    }

    public Field50F setNumber3(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field50F setNumber3(Number component6) {
        this.setComponent6(component6);
        return this;
    }

    public Field50F setComponent7(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public Field50F setNameAndAddress3(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public Field50F setComponent8(String component8) {
        this.setComponent(8, component8);
        return this;
    }

    public Field50F setComponent8(Number component8) {
        if (component8 != null) {
            this.setComponent(8, Integer.toString(component8.intValue()));
        }
        return this;
    }

    public Field50F setNumber4(String component8) {
        this.setComponent(8, component8);
        return this;
    }

    public Field50F setNumber4(Number component8) {
        this.setComponent8(component8);
        return this;
    }

    public Field50F setComponent9(String component9) {
        this.setComponent(9, component9);
        return this;
    }

    public Field50F setNameAndAddress4(String component9) {
        this.setComponent(9, component9);
        return this;
    }

    @Override
    public String getName() {
        return "50F";
    }

    public static Field50F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("50F");
        if (t == null) {
            return null;
        }
        return new Field50F(t);
    }

    public static Field50F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field50F.get(msg.getBlock4());
    }

    public static List<Field50F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field50F.getAll(msg.getBlock4());
    }

    public static List<Field50F> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("50F");
        if (arr != null && arr.length > 0) {
            ArrayList<Field50F> result = new ArrayList<Field50F>(arr.length);
            for (Tag f : arr) {
                result.add(new Field50F(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field50F cp = Field50F.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field50F cp = Field50F.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field50F cp = Field50F.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field50F fromJson(String json) {
        Field50F field = new Field50F();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("partyIdentifier") != null) {
            field.setComponent1(jsonObject.get("partyIdentifier").getAsString());
        }
        if (jsonObject.get("number1") != null) {
            field.setComponent2(jsonObject.get("number1").getAsString());
        }
        if (jsonObject.get("nameAndAddress1") != null) {
            field.setComponent3(jsonObject.get("nameAndAddress1").getAsString());
        }
        if (jsonObject.get("number2") != null) {
            field.setComponent4(jsonObject.get("number2").getAsString());
        }
        if (jsonObject.get("nameAndAddress2") != null) {
            field.setComponent5(jsonObject.get("nameAndAddress2").getAsString());
        }
        if (jsonObject.get("number3") != null) {
            field.setComponent6(jsonObject.get("number3").getAsString());
        }
        if (jsonObject.get("nameAndAddress3") != null) {
            field.setComponent7(jsonObject.get("nameAndAddress3").getAsString());
        }
        if (jsonObject.get("number4") != null) {
            field.setComponent8(jsonObject.get("number4").getAsString());
        }
        if (jsonObject.get("nameAndAddress4") != null) {
            field.setComponent9(jsonObject.get("nameAndAddress4").getAsString());
        }
        return field;
    }

    @Override
    public String getComponentLabel(int number) {
        String label;
        if (number == 1 && StringUtils.startsWith((CharSequence)this.getComponent1(), (CharSequence)"/")) {
            return "Account";
        }
        if ((number == 3 || number == 5 || number == 7 || number == 9) && (label = this.getLabelForLineNumber(this.getComponent(number - 1))) != null) {
            return label;
        }
        return super.getComponentLabel(number);
    }

    public String getLabelForLineNumber(String lineIdentifier) {
        if (StringUtils.isNumeric((CharSequence)StringUtils.trimToNull((String)lineIdentifier))) {
            int number = Integer.valueOf(lineIdentifier.trim());
            if (number == 1) {
                return "Name of the Ordering Customer";
            }
            if (number == 2) {
                return "Address Line";
            }
            if (number == 3) {
                return "Country and Town";
            }
            if (number == 4) {
                return "Date of Birth";
            }
            if (number == 5) {
                return "Place of Birth";
            }
            if (number == 6) {
                return "Customer Identification Number";
            }
            if (number == 7) {
                return "National Identity Number";
            }
            if (number == 8) {
                return "Additional Information";
            }
        }
        return null;
    }

    public List<String> detailsByNumber(int lineIdentifier) {
        ArrayList<String> result = new ArrayList<String>();
        String number = String.valueOf(lineIdentifier);
        if (StringUtils.equals((CharSequence)number, (CharSequence)this.getComponent2()) && StringUtils.isNotBlank((CharSequence)this.getComponent3())) {
            result.add(this.getComponent3());
        }
        if (StringUtils.equals((CharSequence)number, (CharSequence)this.getComponent4()) && StringUtils.isNotBlank((CharSequence)this.getComponent5())) {
            result.add(this.getComponent5());
        }
        if (StringUtils.equals((CharSequence)number, (CharSequence)this.getComponent6()) && StringUtils.isNotBlank((CharSequence)this.getComponent7())) {
            result.add(this.getComponent7());
        }
        if (StringUtils.equals((CharSequence)number, (CharSequence)this.getComponent8()) && StringUtils.isNotBlank((CharSequence)this.getComponent9())) {
            result.add(this.getComponent9());
        }
        return result;
    }

    public boolean contains(int lineIdentifier) {
        String number = String.valueOf(lineIdentifier);
        if (StringUtils.equals((CharSequence)number, (CharSequence)this.getComponent2()) && StringUtils.isNotBlank((CharSequence)this.getComponent3())) {
            return true;
        }
        if (StringUtils.equals((CharSequence)number, (CharSequence)this.getComponent4()) && StringUtils.isNotBlank((CharSequence)this.getComponent5())) {
            return true;
        }
        if (StringUtils.equals((CharSequence)number, (CharSequence)this.getComponent6()) && StringUtils.isNotBlank((CharSequence)this.getComponent7())) {
            return true;
        }
        return StringUtils.equals((CharSequence)number, (CharSequence)this.getComponent8()) && StringUtils.isNotBlank((CharSequence)this.getComponent9());
    }
}

