/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field56B
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2019;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "56B";
    public static final String F_56B = "56B";
    public static final String PARSER_PATTERN = "[[/c][/S]$]S";
    public static final String COMPONENTS_PATTERN = "SSS";
    public static final Integer DC_MARK = 1;
    public static final Integer ACCOUNT = 2;
    public static final Integer LOCATION = 3;

    public Field56B() {
        super(3);
    }

    public Field56B(String value) {
        super(value);
    }

    public Field56B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"56B")) {
            throw new IllegalArgumentException("cannot create field 56B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field56B newInstance(Field56B source) {
        Field56B cp = new Field56B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("56B", value);
    }

    public static Tag emptyTag() {
        return new Tag("56B", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0).startsWith("/")) {
            String dcMark = SwiftParseUtils.getTokenFirst(lines.get(0), "/", "/");
            if (StringUtils.isNotEmpty((CharSequence)dcMark) && dcMark.length() == 1) {
                this.setComponent1(dcMark);
                this.setComponent2(SwiftParseUtils.getTokenSecondLast(StringUtils.substring((String)lines.get(0), (int)1), "/"));
            } else {
                this.setComponent2(StringUtils.substring((String)lines.get(0), (int)1));
            }
            if (lines.size() > 1) {
                this.setComponent3(lines.get(1));
            }
        } else {
            this.setComponent3(lines.get(0));
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        if (this.getComponent3() != null) {
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(this.getComponent3());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 56B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[[/<DC>][/34x]$]35x";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Account");
        result.add("Location");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "dCMark");
        result.put(2, "account");
        result.put(3, "location");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent1AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent2AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(2);
    }

    public String getAccount() {
        String c = this.getComponent(2);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        DeprecationUtils.phase3(this.getClass(), "getComponent3AsString()", "Use use #getComponent(int) instead.");
        return this.getComponent(3);
    }

    public String getLocation() {
        return this.getComponent(3);
    }

    public Field56B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field56B setDCMark(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field56B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field56B setAccount(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field56B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field56B setLocation(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    @Override
    public String getName() {
        return "56B";
    }

    public static Field56B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("56B");
        if (t == null) {
            return null;
        }
        return new Field56B(t);
    }

    public static Field56B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field56B.get(msg.getBlock4());
    }

    public static List<Field56B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field56B.getAll(msg.getBlock4());
    }

    public static List<Field56B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("56B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field56B> result = new ArrayList<Field56B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field56B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field56B cp = Field56B.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field56B cp = Field56B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field56B cp = Field56B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field56B fromJson(String json) {
        Field56B field = new Field56B();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("dCMark") != null) {
            field.setComponent1(jsonObject.get("dCMark").getAsString());
        }
        if (jsonObject.get("account") != null) {
            field.setComponent2(jsonObject.get("account").getAsString());
        }
        if (jsonObject.get("location") != null) {
            field.setComponent3(jsonObject.get("location").getAsString());
        }
        return field;
    }
}

